(*
% File     : SET732+4 : ILTP v1.1.2
% Domain   : Set Theory (Mappings)
% Problem  : Property of restriction 3
% Version  : [Pas99] axioms.
% English  : If F is a mapping from A to B,and G equal to F on A and 
%            C =image2(F,A) and F is injective, then G is one-to-one.
% Refs     : [Pas99] Pastre (1999), Email to G. Sutcliffe
% Source   : [Pas99]
% Names    :
% Status   : Theorem
% Rating   : 0.91 v3.1.0, 0.89 v2.7.0, 0.83 v2.6.0, 0.86 v2.5.0, 0.88 v2.4.0, 0.75 v2.3.0, 0.67 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   29 (   1 unit)
%            Number of atoms       :  137 (   7 equality)
%            Maximal formula depth :   19 (   9 average)
%            Number of connectives :  110 (   2 ~  ;   2  |;  55  &)
%                                         (  31 <=>;  20 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   16 (   0 propositional; 2-6 arity)
%            Number of functors    :   15 (   1 constant; 0-5 arity)
%            Number of variables   :  140 (   0 singleton; 131 !;   9 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
% Bugfixes : v2.2.1 - Bugfixes in SET006+1.ax.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable surjective_ : Universe -> Universe -> Universe -> Prop.
Variable subset_ : Universe -> Universe -> Prop.
Variable one_to_one_ : Universe -> Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable maps_ : Universe -> Universe -> Universe -> Prop.
Variable isomorphism_ : Universe -> Universe -> Universe -> Universe -> Universe -> Prop.
Variable inverse_predicate_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable injective_ : Universe -> Universe -> Universe -> Prop.
Variable increasing_ : Universe -> Universe -> Universe -> Universe -> Universe -> Prop.
Variable identity_ : Universe -> Universe -> Prop.
Variable equal_set_ : Universe -> Universe -> Prop.
Variable equal_maps_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable decreasing_ : Universe -> Universe -> Universe -> Universe -> Universe -> Prop.
Variable compose_predicate_ : Universe -> Universe -> Universe -> Universe -> Universe -> Universe -> Prop.
Variable apply_ : Universe -> Universe -> Universe -> Prop.

Variable unordered_pair_ : Universe -> Universe -> Universe.
Variable union_ : Universe -> Universe -> Universe.
Variable sum_ : Universe -> Universe.
Variable singleton_ : Universe -> Universe.
Variable product_ : Universe -> Universe.
Variable power_set_ : Universe -> Universe.
Variable inverse_image3_ : Universe -> Universe -> Universe -> Universe.
Variable inverse_image2_ : Universe -> Universe -> Universe.
Variable inverse_function_ : Universe -> Universe -> Universe -> Universe.
Variable intersection_ : Universe -> Universe -> Universe.
Variable image3_ : Universe -> Universe -> Universe -> Universe.
Variable image2_ : Universe -> Universe -> Universe.
Variable empty_set_ : Universe.
Variable difference_ : Universe -> Universe -> Universe.
Variable compose_function_ : Universe -> Universe -> Universe -> Universe -> Universe -> Universe.

Variable subset_1 : (forall A B : Universe, (subset_ A B <-> (forall X : Universe, (member_ X A -> member_ X B)))).
Variable equal_set_2 : (forall A B : Universe, (equal_set_ A B <-> (subset_ A B /\ subset_ B A))).
Variable power_set_3 : (forall X A : Universe, (member_ X (power_set_ A) <-> subset_ X A)).
Variable intersection_4 : (forall X A B : Universe, (member_ X (intersection_ A B) <-> (member_ X A /\ member_ X B))).
Variable union_5 : (forall X A B : Universe, (member_ X (union_ A B) <-> (member_ X A \/ member_ X B))).
Variable empty_set_6 : (forall X : Universe, ~(member_ X empty_set_)).
Variable difference_7 : (forall B A E : Universe, (member_ B (difference_ E A) <-> (member_ B E /\ ~(member_ B A)))).
Variable singleton_8 : (forall X A : Universe, (member_ X (singleton_ A) <-> X = A)).
Variable unordered_pair_9 : (forall X A B : Universe, (member_ X (unordered_pair_ A B) <-> (X = A \/ X = B))).
Variable sum_10 : (forall X A : Universe, (member_ X (sum_ A) <-> (exists Y : Universe, (member_ Y A /\ member_ X Y)))).
Variable product_11 : (forall X A : Universe, (member_ X (product_ A) <-> (forall Y : Universe, (member_ Y A -> member_ X Y)))).
Variable maps_12 : (forall F A B : Universe, (maps_ F A B <-> ((forall X : Universe, (member_ X A -> (exists Y : Universe, (member_ Y B /\ apply_ F X Y)))) /\ (forall X Y1 Y2 : Universe, ((member_ X A /\ (member_ Y1 B /\ member_ Y2 B)) -> ((apply_ F X Y1 /\ apply_ F X Y2) -> Y1 = Y2)))))).
Variable compose_predicate_13 : (forall H G F A B C : Universe, (compose_predicate_ H G F A B C <-> (forall X Z : Universe, ((member_ X A /\ member_ Z C) -> (apply_ H X Z <-> (exists Y : Universe, (member_ Y B /\ (apply_ F X Y /\ apply_ G Y Z)))))))).
Variable compose_function_14 : (forall G F A B C X Z : Universe, ((member_ X A /\ member_ Z C) -> (apply_ (compose_function_ G F A B C) X Z <-> (exists Y : Universe, (member_ Y B /\ (apply_ F X Y /\ apply_ G Y Z)))))).
Variable equal_maps_15 : (forall F G A B : Universe, (equal_maps_ F G A B <-> (forall X Y1 Y2 : Universe, ((member_ X A /\ (member_ Y1 B /\ member_ Y2 B)) -> ((apply_ F X Y1 /\ apply_ G X Y2) -> Y1 = Y2))))).
Variable identity_16 : (forall F A : Universe, (identity_ F A <-> (forall X : Universe, (member_ X A -> apply_ F X X)))).
Variable injective_17 : (forall F A B : Universe, (injective_ F A B <-> (forall X1 X2 Y : Universe, ((member_ X1 A /\ (member_ X2 A /\ member_ Y B)) -> ((apply_ F X1 Y /\ apply_ F X2 Y) -> X1 = X2))))).
Variable surjective_18 : (forall F A B : Universe, (surjective_ F A B <-> (forall Y : Universe, (member_ Y B -> (exists E : Universe, (member_ E A /\ apply_ F E Y)))))).
Variable one_to_one_19 : (forall F A B : Universe, (one_to_one_ F A B <-> (injective_ F A B /\ surjective_ F A B))).
Variable inverse_predicate_20 : (forall G F A B : Universe, (inverse_predicate_ G F A B <-> (forall X Y : Universe, ((member_ X A /\ member_ Y B) -> (apply_ F X Y <-> apply_ G Y X))))).
Variable inverse_function_21 : (forall F A B X Y : Universe, ((member_ X A /\ member_ Y B) -> (apply_ F X Y <-> apply_ (inverse_function_ F A B) Y X))).
Variable image2_22 : (forall F A Y : Universe, (member_ Y (image2_ F A) <-> (exists X : Universe, (member_ X A /\ apply_ F X Y)))).
Variable image3_23 : (forall F A B Y : Universe, (member_ Y (image3_ F A B) <-> (member_ Y B /\ (exists X : Universe, (member_ X A /\ apply_ F X Y))))).
Variable inverse_image2_24 : (forall F B X : Universe, (member_ X (inverse_image2_ F B) <-> (exists Y : Universe, (member_ Y B /\ apply_ F X Y)))).
Variable inverse_image3_25 : (forall F B A X : Universe, (member_ X (inverse_image3_ F B A) <-> (member_ X A /\ (exists Y : Universe, (member_ Y B /\ apply_ F X Y))))).
Variable increasing_function_26 : (forall F A R B S : Universe, (increasing_ F A R B S <-> (forall X1 Y1 X2 Y2 : Universe, ((member_ X1 A /\ (member_ Y1 B /\ (member_ X2 A /\ (member_ Y2 B /\ (apply_ R X1 X2 /\ (apply_ F X1 Y1 /\ apply_ F X2 Y2)))))) -> apply_ S Y1 Y2)))).
Variable decreasing_function_27 : (forall F A R B S : Universe, (decreasing_ F A R B S <-> (forall X1 Y1 X2 Y2 : Universe, ((member_ X1 A /\ (member_ Y1 B /\ (member_ X2 A /\ (member_ Y2 B /\ (apply_ R X1 X2 /\ (apply_ F X1 Y1 /\ apply_ F X2 Y2)))))) -> apply_ S Y2 Y1)))).
Variable isomorphism_28 : (forall F A R B S : Universe, (isomorphism_ F A R B S <-> (maps_ F A B /\ (one_to_one_ F A B /\ (forall X1 Y1 X2 Y2 : Universe, ((member_ X1 A /\ (member_ Y1 B /\ (member_ X2 A /\ (member_ Y2 B /\ (apply_ F X1 Y1 /\ apply_ F X2 Y2))))) -> (apply_ R X1 X2 <-> apply_ S Y1 Y2))))))).

Theorem thII23_29 : (forall F G A B C : Universe, ((maps_ F A B /\ (subset_ C B /\ ((image2_ F A) = C /\ ((forall X Y : Universe, ((member_ X A /\ member_ Y C) -> (apply_ G X Y <-> apply_ F X Y))) /\ injective_ F A B)))) -> one_to_one_ G A C)).
Proof.
  time hprover.
Qed.

End FOFProblem.
