(*
% File     : SET698+4 : ILTP v1.1.2
% Domain   : Set Theory (Naive)
% Problem  : Property of union and difference
% Version  : [Pas99] axioms.
% English  : A is a subset of B if and only if the union of A and of the 
%            difference of B in E is equal to E.
% Refs     : [Pas99] Pastre (1999), Email to G. Sutcliffe
% Source   : [Pas99]
% Names    :
% Status   : Theorem
% Rating   : 0.91 v3.1.0, 0.89 v2.7.0, 0.83 v2.6.0, 0.86 v2.5.0, 0.88 v2.4.0, 0.50 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   12 (   1 unit)
%            Number of atoms       :   33 (   3 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   23 (   2 ~  ;   2  |;   5  &)
%                                         (  11 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 2-2 arity)
%            Number of functors    :    9 (   1 constant; 0-2 arity)
%            Number of variables   :   31 (   0 singleton;  30 !;   1 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable equal_set_ : Universe -> Universe -> Prop.

Variable unordered_pair_ : Universe -> Universe -> Universe.
Variable union_ : Universe -> Universe -> Universe.
Variable sum_ : Universe -> Universe.
Variable singleton_ : Universe -> Universe.
Variable product_ : Universe -> Universe.
Variable power_set_ : Universe -> Universe.
Variable intersection_ : Universe -> Universe -> Universe.
Variable empty_set_ : Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable subset_1 : (forall A B : Universe, (subset_ A B <-> (forall X : Universe, (member_ X A -> member_ X B)))).
Variable equal_set_2 : (forall A B : Universe, (equal_set_ A B <-> (subset_ A B /\ subset_ B A))).
Variable power_set_3 : (forall X A : Universe, (member_ X (power_set_ A) <-> subset_ X A)).
Variable intersection_4 : (forall X A B : Universe, (member_ X (intersection_ A B) <-> (member_ X A /\ member_ X B))).
Variable union_5 : (forall X A B : Universe, (member_ X (union_ A B) <-> (member_ X A \/ member_ X B))).
Variable empty_set_6 : (forall X : Universe, ~(member_ X empty_set_)).
Variable difference_7 : (forall B A E : Universe, (member_ B (difference_ E A) <-> (member_ B E /\ ~(member_ B A)))).
Variable singleton_8 : (forall X A : Universe, (member_ X (singleton_ A) <-> X = A)).
Variable unordered_pair_9 : (forall X A B : Universe, (member_ X (unordered_pair_ A B) <-> (X = A \/ X = B))).
Variable sum_10 : (forall X A : Universe, (member_ X (sum_ A) <-> (exists Y : Universe, (member_ Y A /\ member_ X Y)))).
Variable product_11 : (forall X A : Universe, (member_ X (product_ A) <-> (forall Y : Universe, (member_ Y A -> member_ X Y)))).

Theorem thI32_12 : (forall A B E : Universe, ((subset_ A E /\ subset_ B E) -> (subset_ A B <-> equal_set_ (union_ (difference_ E A) B) E))).
Proof.
  time hprover.
Qed.

End FOFProblem.
