(*
% File     : SET682+3 : ILTP v1.1.2
% Domain   : Set Theory (Relations)
% Problem  : !x in D : x in domain of R (X to Y) ? y in E : y in range of R
% Version  : [Wor89] axioms : Reduced > Incomplete.
% English  : For every element x in D such that x is in the domain of a 
%            relation R from X to Y there exists an element y in E such that 
%            y is in the range of R.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Wor89] Woronowicz (1989), Relations Defined on Sets
% Source   : [ILF]
% Names    : RELSET_1 (49) [Wor89]
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.22 v2.7.0, 0.50 v2.6.0, 0.29 v2.5.0, 0.25 v2.4.0, 0.25 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   25 (   2 unit)
%            Number of atoms       :   96 (   3 equality)
%            Maximal formula depth :   12 (   6 average)
%            Number of connectives :   77 (   6 ~  ;   0  |;  12  &)
%                                         (   6 <=>;  53 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    5 (   0 propositional; 1-2 arity)
%            Number of functors    :   12 (   2 constant; 0-3 arity)
%            Number of variables   :   58 (   0 singleton;  50 !;   8 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments :
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable relation_like_ : Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable ilf_type_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable subset_type_ : Universe -> Universe.
Variable set_type_ : Universe.
Variable relation_type_ : Universe -> Universe -> Universe.
Variable range_of_ : Universe -> Universe.
Variable range_ : Universe -> Universe -> Universe -> Universe.
Variable power_set_ : Universe -> Universe.
Variable ordered_pair_ : Universe -> Universe -> Universe.
Variable member_type_ : Universe -> Universe.
Variable domain_of_ : Universe -> Universe.
Variable domain_ : Universe -> Universe -> Universe -> Universe.
Variable cross_product_ : Universe -> Universe -> Universe.
Variable binary_relation_type_ : Universe.

Variable p1_1 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C binary_relation_type_ -> (member_ B (domain_of_ C) -> (exists D : Universe, (ilf_type_ D set_type_ /\ member_ D (range_of_ C)))))))).
Variable p2_2 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ((forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> ilf_type_ D (relation_type_ B C))) /\ (forall E : Universe, (ilf_type_ E (relation_type_ B C) -> ilf_type_ E (subset_type_ (cross_product_ B C))))))))).
Variable p3_3 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (exists D : Universe, ilf_type_ D (relation_type_ C B)))))).
Variable p4_4 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, ((~(empty_ C) /\ ilf_type_ C set_type_) -> (ilf_type_ B (member_type_ C) <-> member_ B C))))).
Variable p5_5 : (forall B : Universe, ((~(empty_ B) /\ ilf_type_ B set_type_) -> (exists C : Universe, ilf_type_ C (member_type_ B)))).
Variable p6_6 : (forall B : Universe, (ilf_type_ B set_type_ -> (empty_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> ~(member_ C B)))))).
Variable p7_7 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> ilf_type_ (domain_of_ B) set_type_)).
Variable p8_8 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (cross_product_ B C) set_type_)))).
Variable p9_9 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> ilf_type_ (range_of_ B) set_type_)).
Variable p10_10 : (forall B : Universe, (ilf_type_ B set_type_ -> (ilf_type_ B binary_relation_type_ <-> (relation_like_ B /\ ilf_type_ B set_type_)))).
Variable p11_11 : (exists B : Universe, ilf_type_ B binary_relation_type_).
Variable p12_12 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (ilf_type_ C (subset_type_ B) <-> ilf_type_ C (member_type_ (power_set_ B))))))).
Variable p13_13 : (forall B : Universe, (ilf_type_ B set_type_ -> (exists C : Universe, ilf_type_ C (subset_type_ B)))).
Variable p14_14 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ B (power_set_ C) <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p15_15 : (forall B : Universe, (ilf_type_ B set_type_ -> (~(empty_ (power_set_ B)) /\ ilf_type_ (power_set_ B) set_type_))).
Variable p16_16 : (forall B : Universe, (ilf_type_ B set_type_ -> (relation_like_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ C B -> (exists D : Universe, (ilf_type_ D set_type_ /\ (exists E : Universe, (ilf_type_ E set_type_ /\ C = (ordered_pair_ D E))))))))))).
Variable p17_17 : (forall B : Universe, ((empty_ B /\ ilf_type_ B set_type_) -> relation_like_ B)).
Variable p18_18 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> relation_like_ D)))))).
Variable p19_19 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (ordered_pair_ B C) set_type_)))).
Variable p20_20 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (domain_ B C D) = (domain_of_ D))))))).
Variable p21_21 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> ilf_type_ (domain_ B C D) (subset_type_ B))))))).
Variable p22_22 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (range_ B C D) = (range_of_ D))))))).
Variable p23_23 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> ilf_type_ (range_ B C D) (subset_type_ C))))))).
Variable p24_24 : (forall B : Universe, ilf_type_ B set_type_).

Theorem prove_relset_1_49_25 : (forall B : Universe, ((~(empty_ B) /\ ilf_type_ B set_type_) -> (forall C : Universe, ((~(empty_ C) /\ ilf_type_ C set_type_) -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (forall E : Universe, (ilf_type_ E (member_type_ B) -> (member_ E (domain_ B C D) -> (exists F : Universe, (ilf_type_ F (member_type_ C) /\ member_ F (range_ B C D)))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
