(*
% File     : SET679+3 : ILTP v1.1.2
% Domain   : Set Theory (Relations)
% Problem  : The identity relation on D is not the empty set
% Version  : [Wor89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Wor89] Woronowicz (1989), Relations Defined on Sets
% Source   : [ILF]
% Names    : RELSET_1 (46) [Wor89]
% Status   : Theorem
% Rating   : 0.27 v3.1.0, 0.22 v2.7.0, 0.17 v2.6.0, 0.14 v2.5.0, 0.12 v2.4.0, 0.25 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   24 (   4 unit)
%            Number of atoms       :   82 (   4 equality)
%            Maximal formula depth :   11 (   5 average)
%            Number of connectives :   65 (   7 ~  ;   0  |;   9  &)
%                                         (  11 <=>;  38 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    7 (   0 propositional; 1-2 arity)
%            Number of functors    :    9 (   3 constant; 0-2 arity)
%            Number of variables   :   42 (   0 singleton;  37 !;   5 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments :
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable type_ : Universe -> Universe -> Prop.
Variable relation_like_ : Universe -> Prop.
Variable not_equal_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable ilf_type_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable subset_type_ : Universe -> Universe.
Variable set_type_ : Universe.
Variable power_set_ : Universe -> Universe.
Variable ordered_pair_ : Universe -> Universe -> Universe.
Variable member_type_ : Universe -> Universe.
Variable identity_relation_of_ : Universe -> Universe.
Variable empty_set_ : Universe.
Variable cross_product_ : Universe -> Universe -> Universe.
Variable binary_relation_type_ : Universe.

Variable p1_1 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ C B <-> member_ (ordered_pair_ C C) (identity_relation_of_ B)))))).
Variable p2_2 : (forall B : Universe, (ilf_type_ B set_type_ -> ~(member_ B empty_set_))).
Variable p3a_3 : empty_ empty_set_.
Variable p3b_4 : type_ empty_set_ set_type_.
Variable p4_5 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ (ordered_pair_ C D) (identity_relation_of_ B) <-> (member_ C B /\ C = D)))))))).
Variable p5_6 : (forall B : Universe, (ilf_type_ B set_type_ -> ilf_type_ (identity_relation_of_ B) binary_relation_type_)).
Variable p6_7 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (B = C <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B <-> member_ D C)))))))).
Variable p7_8 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (not_equal_ B C <-> B <> C))))).
Variable p8_9 : (forall B : Universe, (ilf_type_ B set_type_ -> (empty_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> ~(member_ C B)))))).
Variable p9_10 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (ordered_pair_ B C) set_type_)))).
Variable p10_11 : (forall B : Universe, (ilf_type_ B set_type_ -> (ilf_type_ B binary_relation_type_ <-> (relation_like_ B /\ ilf_type_ B set_type_)))).
Variable p11_12 : (exists B : Universe, ilf_type_ B binary_relation_type_).
Variable p12_13 : (forall B : Universe, (ilf_type_ B set_type_ -> (relation_like_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ C B -> (exists D : Universe, (ilf_type_ D set_type_ /\ (exists E : Universe, (ilf_type_ E set_type_ /\ C = (ordered_pair_ D E))))))))))).
Variable p13_14 : (forall B : Universe, ((empty_ B /\ ilf_type_ B set_type_) -> relation_like_ B)).
Variable p14_15 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> relation_like_ D)))))).
Variable p15_16 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (cross_product_ B C) set_type_)))).
Variable p16_17 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (ilf_type_ C (subset_type_ B) <-> ilf_type_ C (member_type_ (power_set_ B))))))).
Variable p17_18 : (forall B : Universe, (ilf_type_ B set_type_ -> (exists C : Universe, ilf_type_ C (subset_type_ B)))).
Variable p18_19 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ B (power_set_ C) <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p19_20 : (forall B : Universe, (ilf_type_ B set_type_ -> (~(empty_ (power_set_ B)) /\ ilf_type_ (power_set_ B) set_type_))).
Variable p20_21 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, ((~(empty_ C) /\ ilf_type_ C set_type_) -> (ilf_type_ B (member_type_ C) <-> member_ B C))))).
Variable p21_22 : (forall B : Universe, ((~(empty_ B) /\ ilf_type_ B set_type_) -> (exists C : Universe, ilf_type_ C (member_type_ B)))).
Variable p22_23 : (forall B : Universe, ilf_type_ B set_type_).

Theorem prove_relset_1_46_24 : (forall B : Universe, ((~(empty_ B) /\ ilf_type_ B set_type_) -> not_equal_ (identity_relation_of_ B) empty_set_)).
Proof.
  time hprover.
Qed.

End FOFProblem.
