(*
% File     : SET675+3 : ILTP v1.1.2
% Domain   : Set Theory (Relations)
% Problem  : R o R^-1(Y) is the range of R & R^-1(R o X) is the domain of R
% Version  : [Wor89] axioms : Reduced > Incomplete.
% English  : A relation R from X to Y composed with the inverse of R applied 
%            to Y is the range of R; and the inverse of R applied to R 
%            composed with X is the domain of R.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Wor89] Woronowicz (1989), Relations Defined on Sets
% Source   : [ILF]
% Names    : RELSET_1 (39) [Wor89]
% Status   : Theorem
% Rating   : 0.27 v3.1.0, 0.22 v2.7.0, 0.17 v2.6.0, 0.14 v2.5.0, 0.12 v2.4.0, 0.25 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   36 (   2 unit)
%            Number of atoms       :  135 (  12 equality)
%            Maximal formula depth :   11 (   6 average)
%            Number of connectives :  103 (   4 ~  ;   0  |;  11  &)
%                                         (   8 <=>;  80 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :   16 (   2 constant; 0-4 arity)
%            Number of variables   :   84 (   0 singleton;  78 !;   6 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments :
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable relation_like_ : Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable ilf_type_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable subset_type_ : Universe -> Universe.
Variable set_type_ : Universe.
Variable relation_type_ : Universe -> Universe -> Universe.
Variable range_of_ : Universe -> Universe.
Variable range_ : Universe -> Universe -> Universe -> Universe.
Variable power_set_ : Universe -> Universe.
Variable ordered_pair_ : Universe -> Universe -> Universe.
Variable member_type_ : Universe -> Universe.
Variable inverse4_ : Universe -> Universe -> Universe -> Universe -> Universe.
Variable inverse2_ : Universe -> Universe -> Universe.
Variable image4_ : Universe -> Universe -> Universe -> Universe -> Universe.
Variable image_ : Universe -> Universe -> Universe.
Variable domain_of_ : Universe -> Universe.
Variable domain_ : Universe -> Universe -> Universe -> Universe.
Variable cross_product_ : Universe -> Universe -> Universe.
Variable binary_relation_type_ : Universe.

Variable p1_1 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> (image_ B (domain_of_ B)) = (range_of_ B))).
Variable p2_2 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> (inverse2_ B (range_of_ B)) = (domain_of_ B))).
Variable p3_3 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> ((image4_ B C D B) = (range_ B C D) /\ (inverse4_ B C D C) = (domain_ B C D)))))))).
Variable p4_4 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ((forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> ilf_type_ D (relation_type_ B C))) /\ (forall E : Universe, (ilf_type_ E (relation_type_ B C) -> ilf_type_ E (subset_type_ (cross_product_ B C))))))))).
Variable p5_5 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (exists D : Universe, ilf_type_ D (relation_type_ C B)))))).
Variable p6_6 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (B = C <-> (subset_ B C /\ subset_ C B)))))).
Variable p7_7 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (inverse2_ B C) set_type_)))).
Variable p8_8 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> ilf_type_ (domain_of_ B) set_type_)).
Variable p9_9 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (cross_product_ B C) set_type_)))).
Variable p10_10 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> ilf_type_ (range_of_ B) set_type_)).
Variable p11_11 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (image_ B C) set_type_)))).
Variable p12_12 : (forall B : Universe, (ilf_type_ B set_type_ -> (ilf_type_ B binary_relation_type_ <-> (relation_like_ B /\ ilf_type_ B set_type_)))).
Variable p13_13 : (exists B : Universe, ilf_type_ B binary_relation_type_).
Variable p14_14 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (ilf_type_ C (subset_type_ B) <-> ilf_type_ C (member_type_ (power_set_ B))))))).
Variable p15_15 : (forall B : Universe, (ilf_type_ B set_type_ -> (exists C : Universe, ilf_type_ C (subset_type_ B)))).
Variable p16_16 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (subset_ B C <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p17_17 : (forall B : Universe, (ilf_type_ B set_type_ -> subset_ B B)).
Variable p18_18 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ B (power_set_ C) <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p19_19 : (forall B : Universe, (ilf_type_ B set_type_ -> (~(empty_ (power_set_ B)) /\ ilf_type_ (power_set_ B) set_type_))).
Variable p20_20 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, ((~(empty_ C) /\ ilf_type_ C set_type_) -> (ilf_type_ B (member_type_ C) <-> member_ B C))))).
Variable p21_21 : (forall B : Universe, ((~(empty_ B) /\ ilf_type_ B set_type_) -> (exists C : Universe, ilf_type_ C (member_type_ B)))).
Variable p22_22 : (forall B : Universe, (ilf_type_ B set_type_ -> (relation_like_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ C B -> (exists D : Universe, (ilf_type_ D set_type_ /\ (exists E : Universe, (ilf_type_ E set_type_ /\ C = (ordered_pair_ D E))))))))))).
Variable p23_23 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> relation_like_ D)))))).
Variable p24_24 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (ordered_pair_ B C) set_type_)))).
Variable p25_25 : (forall B : Universe, (ilf_type_ B set_type_ -> (empty_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> ~(member_ C B)))))).
Variable p26_26 : (forall B : Universe, ((empty_ B /\ ilf_type_ B set_type_) -> relation_like_ B)).
Variable p27_27 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (domain_ B C D) = (domain_of_ D))))))).
Variable p28_28 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> ilf_type_ (domain_ B C D) (subset_type_ B))))))).
Variable p29_29 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (range_ B C D) = (range_of_ D))))))).
Variable p30_30 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> ilf_type_ (range_ B C D) (subset_type_ C))))))).
Variable p31_31 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (forall E : Universe, (ilf_type_ E set_type_ -> (image4_ B C D E) = (image_ D E))))))))).
Variable p32_32 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (forall E : Universe, (ilf_type_ E set_type_ -> ilf_type_ (image4_ B C D E) (subset_type_ C))))))))).
Variable p33_33 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (forall E : Universe, (ilf_type_ E set_type_ -> (inverse4_ B C D E) = (inverse2_ D E))))))))).
Variable p34_34 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (forall E : Universe, (ilf_type_ E set_type_ -> ilf_type_ (inverse4_ B C D E) (subset_type_ B))))))))).
Variable p35_35 : (forall B : Universe, ilf_type_ B set_type_).

Theorem prove_relset_1_39_36 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ C B) -> ((image4_ C B D (inverse4_ C B D B)) = (range_ C B D) /\ (inverse4_ C B D (image4_ C B D C)) = (domain_ C B D)))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
