(*
% File     : SET658+3 : ILTP v1.1.2
% Domain   : Set Theory (Relations)
% Problem  : Every R (X to Y) is (domain of R to range of R)
% Version  : [Wor89] axioms : Reduced > Incomplete.
% English  : Every relation R from X to Y is a relation from the domain of R 
%            to the range of R.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Wor89] Woronowicz (1989), Relations Defined on Sets
% Source   : [ILF]
% Names    : RELSET_1 (20) [Wor89]
% Status   : Theorem
% Rating   : 0.09 v3.1.0, 0.00 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :   29 (   2 unit)
%            Number of atoms       :  106 (   3 equality)
%            Maximal formula depth :   11 (   6 average)
%            Number of connectives :   81 (   4 ~  ;   0  |;  10  &)
%                                         (   9 <=>;  58 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :   12 (   2 constant; 0-3 arity)
%            Number of variables   :   63 (   0 singleton;  55 !;   8 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments :
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable relation_like_ : Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable ilf_type_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable subset_type_ : Universe -> Universe.
Variable set_type_ : Universe.
Variable relation_type_ : Universe -> Universe -> Universe.
Variable range_of_ : Universe -> Universe.
Variable range_ : Universe -> Universe -> Universe -> Universe.
Variable power_set_ : Universe -> Universe.
Variable ordered_pair_ : Universe -> Universe -> Universe.
Variable member_type_ : Universe -> Universe.
Variable domain_of_ : Universe -> Universe.
Variable domain_ : Universe -> Universe -> Universe -> Universe.
Variable cross_product_ : Universe -> Universe -> Universe.
Variable binary_relation_type_ : Universe.

Variable p1_1 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C binary_relation_type_ -> (subset_ (domain_of_ C) B -> ilf_type_ C (relation_type_ B (range_of_ C))))))).
Variable p2_2 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ C (domain_of_ B) <-> (exists D : Universe, (ilf_type_ D set_type_ /\ member_ (ordered_pair_ C D) B))))))).
Variable p3_3 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> ilf_type_ (domain_of_ B) set_type_)).
Variable p4_4 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ C (range_of_ B) <-> (exists D : Universe, (ilf_type_ D set_type_ /\ member_ (ordered_pair_ D C) B))))))).
Variable p5_5 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> ilf_type_ (range_of_ B) set_type_)).
Variable p6_6 : (forall B : Universe, (ilf_type_ B set_type_ -> (ilf_type_ B binary_relation_type_ <-> (relation_like_ B /\ ilf_type_ B set_type_)))).
Variable p7_7 : (exists B : Universe, ilf_type_ B binary_relation_type_).
Variable p8_8 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ((forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> ilf_type_ D (relation_type_ B C))) /\ (forall E : Universe, (ilf_type_ E (relation_type_ B C) -> ilf_type_ E (subset_type_ (cross_product_ B C))))))))).
Variable p9_9 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (exists D : Universe, ilf_type_ D (relation_type_ C B)))))).
Variable p10_10 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (cross_product_ B C) set_type_)))).
Variable p11_11 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (ordered_pair_ B C) set_type_)))).
Variable p12_12 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (ilf_type_ C (subset_type_ B) <-> ilf_type_ C (member_type_ (power_set_ B))))))).
Variable p13_13 : (forall B : Universe, (ilf_type_ B set_type_ -> (exists C : Universe, ilf_type_ C (subset_type_ B)))).
Variable p14_14 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (subset_ B C <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p15_15 : (forall B : Universe, (ilf_type_ B set_type_ -> subset_ B B)).
Variable p16_16 : (forall B : Universe, (ilf_type_ B set_type_ -> (relation_like_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ C B -> (exists D : Universe, (ilf_type_ D set_type_ /\ (exists E : Universe, (ilf_type_ E set_type_ /\ C = (ordered_pair_ D E))))))))))).
Variable p17_17 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> relation_like_ D)))))).
Variable p18_18 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ B (power_set_ C) <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p19_19 : (forall B : Universe, (ilf_type_ B set_type_ -> (~(empty_ (power_set_ B)) /\ ilf_type_ (power_set_ B) set_type_))).
Variable p20_20 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, ((~(empty_ C) /\ ilf_type_ C set_type_) -> (ilf_type_ B (member_type_ C) <-> member_ B C))))).
Variable p21_21 : (forall B : Universe, ((~(empty_ B) /\ ilf_type_ B set_type_) -> (exists C : Universe, ilf_type_ C (member_type_ B)))).
Variable p22_22 : (forall B : Universe, (ilf_type_ B set_type_ -> (empty_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> ~(member_ C B)))))).
Variable p23_23 : (forall B : Universe, ((empty_ B /\ ilf_type_ B set_type_) -> relation_like_ B)).
Variable p24_24 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (domain_ B C D) = (domain_of_ D))))))).
Variable p25_25 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> ilf_type_ (domain_ B C D) (subset_type_ B))))))).
Variable p26_26 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (range_ B C D) = (range_of_ D))))))).
Variable p27_27 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> ilf_type_ (range_ B C D) (subset_type_ C))))))).
Variable p28_28 : (forall B : Universe, ilf_type_ B set_type_).

Theorem prove_relset_1_20_29 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> ilf_type_ B (relation_type_ (domain_of_ B) (range_of_ B)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
