(*
% File     : SET652+3 : ILTP v1.1.2
% Domain   : Set Theory (Relations)
% Problem  : Range of R (X to Y) a subset of Y1 => R is (X to Y1)
% Version  : [Wor89] axioms : Reduced > Incomplete.
% English  : If the range of a relation R from X to Y is a subset of Y1 then 
%            R is a relation from X to Y1.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Wor89] Woronowicz (1989), Relations Defined on Sets
% Source   : [ILF]
% Names    : RELSET_1 (14) [Wor89]
% Status   : Theorem
% Rating   : 0.55 v3.1.0, 0.56 v2.7.0, 0.50 v2.6.0, 0.43 v2.5.0, 0.50 v2.4.0, 0.75 v2.3.0, 0.67 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   27 (   2 unit)
%            Number of atoms       :  105 (   1 equality)
%            Maximal formula depth :   11 (   6 average)
%            Number of connectives :   82 (   4 ~  ;   0  |;  12  &)
%                                         (   8 <=>;  58 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :   10 (   2 constant; 0-2 arity)
%            Number of variables   :   60 (   0 singleton;  53 !;   7 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments :
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable relation_like_ : Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable ilf_type_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable subset_type_ : Universe -> Universe.
Variable set_type_ : Universe.
Variable relation_type_ : Universe -> Universe -> Universe.
Variable range_of_ : Universe -> Universe.
Variable power_set_ : Universe -> Universe.
Variable ordered_pair_ : Universe -> Universe -> Universe.
Variable member_type_ : Universe -> Universe.
Variable domain_of_ : Universe -> Universe.
Variable cross_product_ : Universe -> Universe -> Universe.
Variable binary_relation_type_ : Universe.

Variable p1_1 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> ((subset_ B C /\ subset_ C D) -> subset_ B D))))))).
Variable p2_2 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> subset_ B (cross_product_ (domain_of_ B) (range_of_ B)))).
Variable p3_3 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> (forall E : Universe, (ilf_type_ E set_type_ -> ((subset_ B C /\ subset_ D E) -> subset_ (cross_product_ B D) (cross_product_ C E)))))))))).
Variable p4_4 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ((forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> ilf_type_ D (relation_type_ B C))) /\ (forall E : Universe, (ilf_type_ E (relation_type_ B C) -> ilf_type_ E (subset_type_ (cross_product_ B C))))))))).
Variable p5_5 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (exists D : Universe, ilf_type_ D (relation_type_ C B)))))).
Variable p6_6 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (relation_type_ B C) -> (subset_ (domain_of_ D) B /\ subset_ (range_of_ D) C))))))).
Variable p7_7 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ C (range_of_ B) <-> (exists D : Universe, (ilf_type_ D set_type_ /\ member_ (ordered_pair_ D C) B))))))).
Variable p8_8 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> ilf_type_ (range_of_ B) set_type_)).
Variable p9_9 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (subset_ B C <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p10_10 : (forall B : Universe, (ilf_type_ B binary_relation_type_ -> ilf_type_ (domain_of_ B) set_type_)).
Variable p11_11 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (cross_product_ B C) set_type_)))).
Variable p12_12 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (ordered_pair_ B C) set_type_)))).
Variable p13_13 : (forall B : Universe, (ilf_type_ B set_type_ -> (ilf_type_ B binary_relation_type_ <-> (relation_like_ B /\ ilf_type_ B set_type_)))).
Variable p14_14 : (exists B : Universe, ilf_type_ B binary_relation_type_).
Variable p15_15 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (ilf_type_ C (subset_type_ B) <-> ilf_type_ C (member_type_ (power_set_ B))))))).
Variable p16_16 : (forall B : Universe, (ilf_type_ B set_type_ -> (exists C : Universe, ilf_type_ C (subset_type_ B)))).
Variable p17_17 : (forall B : Universe, (ilf_type_ B set_type_ -> subset_ B B)).
Variable p18_18 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ B (power_set_ C) <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p19_19 : (forall B : Universe, (ilf_type_ B set_type_ -> (~(empty_ (power_set_ B)) /\ ilf_type_ (power_set_ B) set_type_))).
Variable p20_20 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, ((~(empty_ C) /\ ilf_type_ C set_type_) -> (ilf_type_ B (member_type_ C) <-> member_ B C))))).
Variable p21_21 : (forall B : Universe, ((~(empty_ B) /\ ilf_type_ B set_type_) -> (exists C : Universe, ilf_type_ C (member_type_ B)))).
Variable p22_22 : (forall B : Universe, (ilf_type_ B set_type_ -> (relation_like_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ C B -> (exists D : Universe, (ilf_type_ D set_type_ /\ (exists E : Universe, (ilf_type_ E set_type_ /\ C = (ordered_pair_ D E))))))))))).
Variable p23_23 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> relation_like_ D)))))).
Variable p24_24 : (forall B : Universe, (ilf_type_ B set_type_ -> (empty_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> ~(member_ C B)))))).
Variable p25_25 : (forall B : Universe, ((empty_ B /\ ilf_type_ B set_type_) -> relation_like_ B)).
Variable p26_26 : (forall B : Universe, ilf_type_ B set_type_).

Theorem prove_relset_1_14_27 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> (forall E : Universe, (ilf_type_ E (relation_type_ D B) -> (subset_ (range_of_ E) C -> ilf_type_ E (relation_type_ D C)))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
