(*
% File     : SET646+3 : ILTP v1.1.2
% Domain   : Set Theory (Relations)
% Problem  : If x is in X and y is in Y then {<x,y>} is from X to Y.
% Version  : [Wor89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Wor89] Woronowicz (1989), Relations Defined on Sets
% Source   : [ILF]
% Names    : RELSET_1 (8) [Wor89]
% Status   : Theorem
% Rating   : 0.55 v3.1.0, 0.56 v2.7.0, 0.33 v2.6.0, 0.43 v2.5.0, 0.50 v2.4.0, 0.50 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   26 (   1 unit)
%            Number of atoms       :  111 (   7 equality)
%            Maximal formula depth :   12 (   7 average)
%            Number of connectives :   89 (   4 ~  ;   0  |;   9  &)
%                                         (  13 <=>;  63 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :    9 (   1 constant; 0-2 arity)
%            Number of variables   :   65 (   0 singleton;  60 !;   5 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments :
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable relation_like_ : Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable ilf_type_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable unordered_pair_ : Universe -> Universe -> Universe.
Variable subset_type_ : Universe -> Universe.
Variable singleton_ : Universe -> Universe.
Variable set_type_ : Universe.
Variable relation_type_ : Universe -> Universe -> Universe.
Variable power_set_ : Universe -> Universe.
Variable ordered_pair_ : Universe -> Universe -> Universe.
Variable member_type_ : Universe -> Universe.
Variable cross_product_ : Universe -> Universe -> Universe.

Variable p1_1 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (subset_ (singleton_ B) C <-> member_ B C))))).
Variable p2_2 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> (forall E : Universe, (ilf_type_ E set_type_ -> (member_ (ordered_pair_ B C) (cross_product_ D E) <-> (member_ B D /\ member_ C E)))))))))).
Variable p3_3 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ((forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> ilf_type_ D (relation_type_ B C))) /\ (forall E : Universe, (ilf_type_ E (relation_type_ B C) -> ilf_type_ E (subset_type_ (cross_product_ B C))))))))).
Variable p4_4 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (exists D : Universe, ilf_type_ D (relation_type_ C B)))))).
Variable p5_5 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> (D = (singleton_ C) <-> (forall E : Universe, (ilf_type_ E set_type_ -> (member_ E D <-> E = C)))))))))).
Variable p6_6 : (forall B : Universe, (ilf_type_ B set_type_ -> ilf_type_ (singleton_ B) set_type_)).
Variable p7_7 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> (forall E : Universe, (ilf_type_ E set_type_ -> (forall F : Universe, (ilf_type_ F set_type_ -> (F = (ordered_pair_ D E) <-> F = (unordered_pair_ (unordered_pair_ D E) (singleton_ D))))))))))))).
Variable p8_8 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (ordered_pair_ B C) set_type_)))).
Variable p9_9 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (cross_product_ B C) set_type_)))).
Variable p10_10 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (unordered_pair_ B C) set_type_)))).
Variable p11_11 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (unordered_pair_ B C) = (unordered_pair_ C B))))).
Variable p12_12 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (ilf_type_ C (subset_type_ B) <-> ilf_type_ C (member_type_ (power_set_ B))))))).
Variable p13_13 : (forall B : Universe, (ilf_type_ B set_type_ -> (exists C : Universe, ilf_type_ C (subset_type_ B)))).
Variable p14_14 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (B = C <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B <-> member_ D C)))))))).
Variable p15_15 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (subset_ B C <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p16_16 : (forall B : Universe, (ilf_type_ B set_type_ -> subset_ B B)).
Variable p17_17 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ B (power_set_ C) <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p18_18 : (forall B : Universe, (ilf_type_ B set_type_ -> (~(empty_ (power_set_ B)) /\ ilf_type_ (power_set_ B) set_type_))).
Variable p19_19 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, ((~(empty_ C) /\ ilf_type_ C set_type_) -> (ilf_type_ B (member_type_ C) <-> member_ B C))))).
Variable p20_20 : (forall B : Universe, ((~(empty_ B) /\ ilf_type_ B set_type_) -> (exists C : Universe, ilf_type_ C (member_type_ B)))).
Variable p21_21 : (forall B : Universe, (ilf_type_ B set_type_ -> (empty_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> ~(member_ C B)))))).
Variable p22_22 : (forall B : Universe, (ilf_type_ B set_type_ -> (relation_like_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ C B -> (exists D : Universe, (ilf_type_ D set_type_ /\ (exists E : Universe, (ilf_type_ E set_type_ /\ C = (ordered_pair_ D E))))))))))).
Variable p23_23 : (forall B : Universe, ((empty_ B /\ ilf_type_ B set_type_) -> relation_like_ B)).
Variable p24_24 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> relation_like_ D)))))).
Variable p25_25 : (forall B : Universe, ilf_type_ B set_type_).

Theorem prove_relset_1_8_26 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> (forall E : Universe, (ilf_type_ E set_type_ -> ((member_ D B /\ member_ E C) -> ilf_type_ (singleton_ (ordered_pair_ D E)) (relation_type_ B C)))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
