(*
% File     : SET643+3 : ILTP v1.1.2
% Domain   : Set Theory (Relations)
% Problem  : X x Y is a relation from X to Y
% Version  : [Wor89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Wor89] Woronowicz (1989), Relations Defined on Sets
% Source   : [ILF]
% Names    : RELSET_1 (5) [Wor89]
% Status   : Theorem
% Rating   : 0.00 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :   20 (   1 unit)
%            Number of atoms       :   82 (   2 equality)
%            Maximal formula depth :   14 (   6 average)
%            Number of connectives :   66 (   4 ~  ;   0  |;  11  &)
%                                         (   7 <=>;  44 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :    7 (   1 constant; 0-2 arity)
%            Number of variables   :   48 (   0 singleton;  41 !;   7 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments :
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable relation_like_ : Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable ilf_type_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable subset_type_ : Universe -> Universe.
Variable set_type_ : Universe.
Variable relation_type_ : Universe -> Universe -> Universe.
Variable power_set_ : Universe -> Universe.
Variable ordered_pair_ : Universe -> Universe -> Universe.
Variable member_type_ : Universe -> Universe.
Variable cross_product_ : Universe -> Universe -> Universe.

Variable p1_1 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> (subset_ B (cross_product_ C D) -> ilf_type_ B (relation_type_ C D)))))))).
Variable p2_2 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D (cross_product_ B C) <-> (exists E : Universe, (ilf_type_ E set_type_ /\ (exists F : Universe, (ilf_type_ F set_type_ /\ (member_ E B /\ (member_ F C /\ D = (ordered_pair_ E F)))))))))))))).
Variable p3_3 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (cross_product_ B C) set_type_)))).
Variable p4_4 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ((forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> ilf_type_ D (relation_type_ B C))) /\ (forall E : Universe, (ilf_type_ E (relation_type_ B C) -> ilf_type_ E (subset_type_ (cross_product_ B C))))))))).
Variable p5_5 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (exists D : Universe, ilf_type_ D (relation_type_ C B)))))).
Variable p6_6 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (ordered_pair_ B C) set_type_)))).
Variable p7_7 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (ilf_type_ C (subset_type_ B) <-> ilf_type_ C (member_type_ (power_set_ B))))))).
Variable p8_8 : (forall B : Universe, (ilf_type_ B set_type_ -> (exists C : Universe, ilf_type_ C (subset_type_ B)))).
Variable p9_9 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (subset_ B C <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p10_10 : (forall B : Universe, (ilf_type_ B set_type_ -> subset_ B B)).
Variable p11_11 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ B (power_set_ C) <-> (forall D : Universe, (ilf_type_ D set_type_ -> (member_ D B -> member_ D C)))))))).
Variable p12_12 : (forall B : Universe, (ilf_type_ B set_type_ -> (~(empty_ (power_set_ B)) /\ ilf_type_ (power_set_ B) set_type_))).
Variable p13_13 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, ((~(empty_ C) /\ ilf_type_ C set_type_) -> (ilf_type_ B (member_type_ C) <-> member_ B C))))).
Variable p14_14 : (forall B : Universe, ((~(empty_ B) /\ ilf_type_ B set_type_) -> (exists C : Universe, ilf_type_ C (member_type_ B)))).
Variable p15_15 : (forall B : Universe, (ilf_type_ B set_type_ -> (empty_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> ~(member_ C B)))))).
Variable p16_16 : (forall B : Universe, (ilf_type_ B set_type_ -> (relation_like_ B <-> (forall C : Universe, (ilf_type_ C set_type_ -> (member_ C B -> (exists D : Universe, (ilf_type_ D set_type_ /\ (exists E : Universe, (ilf_type_ E set_type_ /\ C = (ordered_pair_ D E))))))))))).
Variable p17_17 : (forall B : Universe, ((empty_ B /\ ilf_type_ B set_type_) -> relation_like_ B)).
Variable p18_18 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> (forall D : Universe, (ilf_type_ D (subset_type_ (cross_product_ B C)) -> relation_like_ D)))))).
Variable p19_19 : (forall B : Universe, ilf_type_ B set_type_).

Theorem prove_relset_1_5_20 : (forall B : Universe, (ilf_type_ B set_type_ -> (forall C : Universe, (ilf_type_ C set_type_ -> ilf_type_ (cross_product_ B C) (relation_type_ B C))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
