(*
% File     : SET638+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : If X (= Y U Z and X ^ Z = the empty set , then X (= Y
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : If X is a subset of the union of Y and Z and the intersection 
%            of X and Z is the empty set, then X is a subset of Y.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (120) [TS89] 
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.11 v2.7.0, 0.17 v2.6.0, 0.14 v2.5.0, 0.00 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0, 0.75 v1.0.0
% Syntax   : Number of formulae    :   15 (   7 unit)
%            Number of atoms       :   29 (   8 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :   16 (   2 ~  ;   1  |;   3  &)
%                                         (   7 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-2 arity)
%            Number of functors    :    3 (   1 constant; 0-2 arity)
%            Number of variables   :   33 (   0 singleton;  33 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable union_ : Universe -> Universe -> Universe.
Variable intersection_ : Universe -> Universe -> Universe.
Variable empty_set_ : Universe.

Variable intersection_is_subset_1 : (forall B C : Universe, subset_ (intersection_ B C) B).
Variable subset_intersection_2 : (forall B C : Universe, (subset_ B C -> (intersection_ B C) = B)).
Variable union_empty_set_3 : (forall B : Universe, (union_ B empty_set_) = B).
Variable intersection_distributes_over_union_4 : (forall B C D : Universe, (intersection_ B (union_ C D)) = (union_ (intersection_ B C) (intersection_ B D))).
Variable union_defn_5 : (forall B C D : Universe, (member_ D (union_ B C) <-> (member_ D B \/ member_ D C))).
Variable empty_set_defn_6 : (forall B : Universe, ~(member_ B empty_set_)).
Variable intersection_defn_7 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable subset_defn_8 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable equal_defn_9 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable commutativity_of_union_10 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable commutativity_of_intersection_11 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable reflexivity_of_subset_12 : (forall B : Universe, subset_ B B).
Variable empty_defn_13 : (forall B : Universe, (empty_ B <-> (forall C : Universe, ~(member_ C B)))).
Variable equal_member_defn_14 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).

Theorem prove_th120_15 : (forall B C D : Universe, ((subset_ B (union_ C D) /\ (intersection_ B D) = empty_set_) -> subset_ B C)).
Proof.
  time hprover.
Qed.

End FOFProblem.
