(*
% File     : SET635+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : X ^ (Y \ Z) = X ^ Y \ X ^ Z
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : The intersection of X and the difference of Y and Z is the 
%            intersection of X and the difference of Y and the intersection 
%            of X and Z.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (117) [TS89] 
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.11 v2.7.0, 0.00 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   16 (   9 unit)
%            Number of atoms       :   28 (   9 equality)
%            Maximal formula depth :    7 (   4 average)
%            Number of connectives :   15 (   3 ~  ;   0  |;   3  &)
%                                         (   8 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-2 arity)
%            Number of functors    :    4 (   1 constant; 0-2 arity)
%            Number of variables   :   36 (   0 singleton;  36 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable union_ : Universe -> Universe -> Universe.
Variable intersection_ : Universe -> Universe -> Universe.
Variable empty_set_ : Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable intersection_is_subset_1 : (forall B C : Universe, subset_ (intersection_ B C) B).
Variable difference_empty_set_2 : (forall B C : Universe, ((difference_ B C) = empty_set_ <-> subset_ B C)).
Variable union_empty_set_3 : (forall B : Universe, (union_ B empty_set_) = B).
Variable difference_and_intersection_and_union_4 : (forall B C D : Universe, (difference_ B (intersection_ C D)) = (union_ (difference_ B C) (difference_ B D))).
Variable difference_and_intersection_5 : (forall B C D : Universe, (intersection_ B (difference_ C D)) = (difference_ (intersection_ B C) D)).
Variable intersection_defn_6 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable difference_defn_7 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable equal_defn_8 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable commutativity_of_union_9 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable empty_set_defn_10 : (forall B : Universe, ~(member_ B empty_set_)).
Variable commutativity_of_intersection_11 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable subset_defn_12 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_13 : (forall B : Universe, subset_ B B).
Variable equal_member_defn_14 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).
Variable empty_defn_15 : (forall B : Universe, (empty_ B <-> (forall C : Universe, ~(member_ C B)))).

Theorem prove_th117_16 : (forall B C D : Universe, (intersection_ B (difference_ C D)) = (difference_ (intersection_ B C) (intersection_ B D))).
Proof.
  time hprover.
Qed.

End FOFProblem.
