(*
% File     : SET631+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : If X intersects the difference of Y and Z, then X intersects Y
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (113) [TS89] 
% Status   : Theorem
% Rating   : 0.00 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.50 v1.0.0
% Syntax   : Number of formulae    :    4 (   0 unit)
%            Number of atoms       :   10 (   0 equality)
%            Maximal formula depth :    7 (   6 average)
%            Number of connectives :    7 (   1 ~  ;   0  |;   2  &)
%                                         (   2 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    2 (   0 propositional; 2-2 arity)
%            Number of functors    :    1 (   0 constant; 2-2 arity)
%            Number of variables   :   11 (   0 singleton;  10 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable member_ : Universe -> Universe -> Prop.
Variable intersect_ : Universe -> Universe -> Prop.

Variable difference_ : Universe -> Universe -> Universe.

Variable difference_defn_1 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable intersect_defn_2 : (forall B C : Universe, (intersect_ B C <-> (exists D : Universe, (member_ D B /\ member_ D C)))).
Variable symmetry_of_intersect_3 : (forall B C : Universe, (intersect_ B C -> intersect_ C B)).

Theorem prove_th113_4 : (forall B C D : Universe, (intersect_ B (difference_ C D) -> intersect_ B C)).
Proof.
  time hprover.
Qed.

End FOFProblem.
