(*
% File     : SET627+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : X is disjoint from the empty set
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (104) [TS89] 
% Status   : Theorem
% Rating   : 0.11 v3.1.0, 0.00 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :    6 (   2 unit)
%            Number of atoms       :   11 (   0 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :    8 (   3 ~  ;   0  |;   1  &)
%                                         (   3 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   11 (   0 singleton;  10 !;   1 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable member_ : Universe -> Universe -> Prop.
Variable intersect_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.
Variable disjoint_ : Universe -> Universe -> Prop.

Variable empty_set_ : Universe.

Variable empty_set_defn_1 : (forall B : Universe, ~(member_ B empty_set_)).
Variable intersect_defn_2 : (forall B C : Universe, (intersect_ B C <-> (exists D : Universe, (member_ D B /\ member_ D C)))).
Variable disjoint_defn_3 : (forall B C : Universe, (disjoint_ B C <-> ~(intersect_ B C))).
Variable symmetry_of_intersect_4 : (forall B C : Universe, (intersect_ B C -> intersect_ C B)).
Variable empty_defn_5 : (forall B : Universe, (empty_ B <-> (forall C : Universe, ~(member_ C B)))).

Theorem prove_th104_6 : (forall B : Universe, disjoint_ B empty_set_).
Proof.
  time hprover.
Qed.

End FOFProblem.
