(*
% File     : SET626+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : If X intersects the intersection of Y and Z, then X intersects Y
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (102) [TS89] 
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.11 v2.7.0, 0.00 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    6 (   1 unit)
%            Number of atoms       :   14 (   2 equality)
%            Maximal formula depth :    6 (   5 average)
%            Number of connectives :    8 (   0 ~  ;   0  |;   2  &)
%                                         (   4 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    1 (   0 constant; 2-2 arity)
%            Number of variables   :   16 (   0 singleton;  15 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable member_ : Universe -> Universe -> Prop.
Variable intersect_ : Universe -> Universe -> Prop.

Variable intersection_ : Universe -> Universe -> Universe.

Variable intersection_defn_1 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable intersect_defn_2 : (forall B C : Universe, (intersect_ B C <-> (exists D : Universe, (member_ D B /\ member_ D C)))).
Variable commutativity_of_intersection_3 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable symmetry_of_intersect_4 : (forall B C : Universe, (intersect_ B C -> intersect_ C B)).
Variable equal_member_defn_5 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).

Theorem prove_th102_6 : (forall B C D : Universe, (intersect_ B (intersection_ C D) -> intersect_ B C)).
Proof.
  time hprover.
Qed.

End FOFProblem.
