(*
% File     : SET624+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : X intersects Y U Z iff X intersects Y or X intersects Z
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : X intersects the union of Y and Z iff X intersects Y or X 
%            intersects Z.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (100) [TS89] 
% Status   : Theorem
% Rating   : 0.64 v3.1.0, 0.67 v2.7.0, 0.50 v2.6.0, 0.43 v2.5.0, 0.50 v2.4.0, 0.50 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    6 (   1 unit)
%            Number of atoms       :   15 (   2 equality)
%            Maximal formula depth :    6 (   5 average)
%            Number of connectives :    9 (   0 ~  ;   2  |;   1  &)
%                                         (   5 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    1 (   0 constant; 2-2 arity)
%            Number of variables   :   16 (   0 singleton;  15 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable member_ : Universe -> Universe -> Prop.
Variable intersect_ : Universe -> Universe -> Prop.

Variable union_ : Universe -> Universe -> Universe.

Variable union_defn_1 : (forall B C D : Universe, (member_ D (union_ B C) <-> (member_ D B \/ member_ D C))).
Variable intersect_defn_2 : (forall B C : Universe, (intersect_ B C <-> (exists D : Universe, (member_ D B /\ member_ D C)))).
Variable commutativity_of_union_3 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable symmetry_of_intersect_4 : (forall B C : Universe, (intersect_ B C -> intersect_ C B)).
Variable equal_member_defn_5 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).

Theorem prove_intersect_with_union_6 : (forall B C D : Universe, (intersect_ B (union_ C D) <-> (intersect_ B C \/ intersect_ B D))).
Proof.
  time hprover.
Qed.

End FOFProblem.
