(*
% File     : SET623+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : (X sym\ Y) sym\ Z = X sym\ (Y sym\ Z)
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : The symmetric difference of (the symmetric difference of X and 
%            Y) and Z is the symmetric difference of X and (the symmetric 
%            difference of Y and Z).
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (99) [TS89] 
% Status   : Unsolved
% Rating   : 1.00 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   15 (  12 unit)
%            Number of atoms       :   21 (  13 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :    6 (   0 ~  ;   0  |;   1  &)
%                                         (   4 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    4 (   0 constant; 2-2 arity)
%            Number of variables   :   37 (   0 singleton;  37 !;   0 ?)
%            Maximal term depth    :    3 (   2 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.

Variable union_ : Universe -> Universe -> Universe.
Variable symmetric_difference_ : Universe -> Universe -> Universe.
Variable intersection_ : Universe -> Universe -> Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable symmetric_difference_defn_1 : (forall B C : Universe, (symmetric_difference_ B C) = (union_ (difference_ B C) (difference_ C B))).
Variable associativity_of_union_2 : (forall B C D : Universe, (union_ (union_ B C) D) = (union_ B (union_ C D))).
Variable associativity_of_intersection_3 : (forall B C D : Universe, (intersection_ (intersection_ B C) D) = (intersection_ B (intersection_ C D))).
Variable difference_difference_union1_4 : (forall B C D : Universe, (difference_ B (difference_ C D)) = (union_ (difference_ B C) (intersection_ B D))).
Variable difference_union_intersection_5 : (forall B C : Universe, (difference_ (union_ B C) (intersection_ B C)) = (union_ (difference_ B C) (difference_ C B))).
Variable difference_difference_union2_6 : (forall B C D : Universe, (difference_ (difference_ B C) D) = (difference_ B (union_ C D))).
Variable difference_distributes_over_union_7 : (forall B C D : Universe, (difference_ (union_ B C) D) = (union_ (difference_ B D) (difference_ C D))).
Variable equal_defn_8 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable commutativity_of_union_9 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable commutativity_of_intersection_10 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable commutativity_of_symmetric_difference_11 : (forall B C : Universe, (symmetric_difference_ B C) = (symmetric_difference_ C B)).
Variable equal_member_defn_12 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).
Variable subset_defn_13 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_14 : (forall B : Universe, subset_ B B).

Theorem prove_th99_15 : (forall B C D : Universe, (symmetric_difference_ (symmetric_difference_ B C) D) = (symmetric_difference_ B (symmetric_difference_ C D))).
Proof.
  time hprover.
Qed.

End FOFProblem.
