(*
% File     : SET620+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : X sym\ Y = (X U Y) \ X ^ Y
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : The symmetric difference of X and Y is the difference of (the 
%            union of X and Y) and the intersection of X and Y.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (96) [TS89] 
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.11 v2.7.0, 0.00 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   14 (   8 unit)
%            Number of atoms       :   26 (   9 equality)
%            Maximal formula depth :    7 (   4 average)
%            Number of connectives :   13 (   1 ~  ;   1  |;   3  &)
%                                         (   7 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    4 (   0 constant; 2-2 arity)
%            Number of variables   :   33 (   0 singleton;  33 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.

Variable union_ : Universe -> Universe -> Universe.
Variable symmetric_difference_ : Universe -> Universe -> Universe.
Variable intersection_ : Universe -> Universe -> Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable symmetric_difference_defn_1 : (forall B C : Universe, (symmetric_difference_ B C) = (union_ (difference_ B C) (difference_ C B))).
Variable difference_into_intersection_2 : (forall B C : Universe, (difference_ B (intersection_ B C)) = (difference_ B C)).
Variable difference_distributes_over_union_3 : (forall B C D : Universe, (difference_ (union_ B C) D) = (union_ (difference_ B D) (difference_ C D))).
Variable union_defn_4 : (forall B C D : Universe, (member_ D (union_ B C) <-> (member_ D B \/ member_ D C))).
Variable intersection_defn_5 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable difference_defn_6 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable equal_defn_7 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable commutativity_of_union_8 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable commutativity_of_intersection_9 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable commutativity_of_symmetric_difference_10 : (forall B C : Universe, (symmetric_difference_ B C) = (symmetric_difference_ C B)).
Variable equal_member_defn_11 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).
Variable subset_defn_12 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_13 : (forall B : Universe, subset_ B B).

Theorem prove_th96_14 : (forall B C : Universe, (symmetric_difference_ B C) = (difference_ (union_ B C) (intersection_ B C))).
Proof.
  time hprover.
Qed.

End FOFProblem.
