(*
% File     : SET617+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : X sym\ the empty set = X and the empty set sym\ X = X
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : The symmetric difference of X and the empty set is X and the 
%            symmetric difference of the empty set and X is X.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (92) [TS89] 
% Status   : Theorem
% Rating   : 0.27 v3.1.0, 0.22 v2.7.0, 0.17 v2.6.0, 0.14 v2.5.0, 0.12 v2.4.0, 0.25 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   13 (   8 unit)
%            Number of atoms       :   21 (  10 equality)
%            Maximal formula depth :    6 (   3 average)
%            Number of connectives :   10 (   2 ~  ;   0  |;   2  &)
%                                         (   5 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-2 arity)
%            Number of functors    :    4 (   1 constant; 0-2 arity)
%            Number of variables   :   22 (   0 singleton;  22 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable union_ : Universe -> Universe -> Universe.
Variable symmetric_difference_ : Universe -> Universe -> Universe.
Variable empty_set_ : Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable symmetric_difference_defn_1 : (forall B C : Universe, (symmetric_difference_ B C) = (union_ (difference_ B C) (difference_ C B))).
Variable union_empty_set_2 : (forall B : Universe, (union_ B empty_set_) = B).
Variable no_difference_with_empty_set1_3 : (forall B : Universe, (difference_ B empty_set_) = B).
Variable no_difference_with_empty_set2_4 : (forall B : Universe, (difference_ empty_set_ B) = empty_set_).
Variable empty_set_defn_5 : (forall B : Universe, ~(member_ B empty_set_)).
Variable equal_defn_6 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable commutativity_of_union_7 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable commutativity_of_symmetric_difference_8 : (forall B C : Universe, (symmetric_difference_ B C) = (symmetric_difference_ C B)).
Variable equal_member_defn_9 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).
Variable subset_defn_10 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_11 : (forall B : Universe, subset_ B B).
Variable empty_defn_12 : (forall B : Universe, (empty_ B <-> (forall C : Universe, ~(member_ C B)))).

Theorem prove_th92_13 : (forall B : Universe, ((symmetric_difference_ B empty_set_) = B /\ (symmetric_difference_ empty_set_ B) = B)).
Proof.
  time hprover.
Qed.

End FOFProblem.
