(*
% File     : SET611+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : X ^ Y = the empty set iff X \ Y = X
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : The intersection of X and Y is the empty set iff the difference 
%            of X and Y is X.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (84) [TS89] 
% Status   : Theorem
% Rating   : 0.45 v3.1.0, 0.44 v2.7.0, 0.33 v2.6.0, 0.71 v2.5.0, 0.50 v2.4.0, 0.25 v2.3.0, 0.00 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   11 (   3 unit)
%            Number of atoms       :   25 (   6 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   17 (   3 ~  ;   0  |;   3  &)
%                                         (   9 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-2 arity)
%            Number of functors    :    3 (   1 constant; 0-2 arity)
%            Number of variables   :   25 (   0 singleton;  25 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable intersection_ : Universe -> Universe -> Universe.
Variable empty_set_ : Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable member_equal_1 : (forall B C : Universe, ((forall D : Universe, (member_ D B <-> member_ D C)) -> B = C)).
Variable intersection_defn_2 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable difference_defn_3 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable empty_set_defn_4 : (forall B : Universe, ~(member_ B empty_set_)).
Variable equal_defn_5 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable commutativity_of_intersection_6 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable equal_member_defn_7 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).
Variable subset_defn_8 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_9 : (forall B : Universe, subset_ B B).
Variable empty_defn_10 : (forall B : Universe, (empty_ B <-> (forall C : Universe, ~(member_ C B)))).

Theorem prove_th84_11 : (forall B C : Universe, ((intersection_ B C) = empty_set_ <-> (difference_ B C) = B)).
Proof.
  time hprover.
Qed.

End FOFProblem.
