(*
% File     : SET609+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : X \ (Y \ Z) = (X \ Y) U X ^ Z
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : The difference of X and (the difference of Y and Z) is the 
%            union of (the difference of X and Y) and the intersection of 
%            X and Z.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (81) [TS89] 
% Status   : Theorem
% Rating   : 0.82 v3.1.0, 0.89 v2.7.0, 0.83 v2.6.0, 0.86 v2.5.0, 0.88 v2.4.0, 0.50 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   10 (   4 unit)
%            Number of atoms       :   22 (   5 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   13 (   1 ~  ;   1  |;   3  &)
%                                         (   7 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    3 (   0 constant; 2-2 arity)
%            Number of variables   :   25 (   0 singleton;  25 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.

Variable union_ : Universe -> Universe -> Universe.
Variable intersection_ : Universe -> Universe -> Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable union_defn_1 : (forall B C D : Universe, (member_ D (union_ B C) <-> (member_ D B \/ member_ D C))).
Variable intersection_defn_2 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable difference_defn_3 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable equal_defn_4 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable commutativity_of_union_5 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable commutativity_of_intersection_6 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable subset_defn_7 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_8 : (forall B : Universe, subset_ B B).
Variable equal_member_defn_9 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).

Theorem prove_th81_10 : (forall B C D : Universe, (difference_ B (difference_ C D)) = (union_ (difference_ B C) (intersection_ B D))).
Proof.
  time hprover.
Qed.

End FOFProblem.
