(*
% File     : SET604+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : The difference of the empty set and X is the empty set
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (75) [TS89] 
% Status   : Theorem
% Rating   : 0.00 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0, 0.50 v1.0.0
% Syntax   : Number of formulae    :    9 (   4 unit)
%            Number of atoms       :   17 (   3 equality)
%            Maximal formula depth :    7 (   4 average)
%            Number of connectives :   11 (   3 ~  ;   0  |;   2  &)
%                                         (   5 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   1 constant; 0-2 arity)
%            Number of variables   :   16 (   0 singleton;  16 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable empty_set_ : Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable empty_set_subset_1 : (forall B : Universe, subset_ empty_set_ B).
Variable difference_empty_set_2 : (forall B C : Universe, ((difference_ B C) = empty_set_ <-> subset_ B C)).
Variable empty_set_defn_3 : (forall B : Universe, ~(member_ B empty_set_)).
Variable difference_defn_4 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable equal_defn_5 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable subset_defn_6 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_7 : (forall B : Universe, subset_ B B).
Variable empty_defn_8 : (forall B : Universe, (empty_ B <-> (forall C : Universe, ~(member_ C B)))).

Theorem prove_no_difference_with_empty_set_9 : (forall B : Universe, (difference_ empty_set_ B) = empty_set_).
Proof.
  time hprover.
Qed.

End FOFProblem.
