(*
% File     : SET603+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : The difference of X and the empty set is X
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (74) [TS89] 
% Status   : Theorem
% Rating   : 0.36 v3.1.0, 0.33 v2.7.0, 0.17 v2.6.0, 0.14 v2.5.0, 0.00 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0, 0.75 v1.0.0
% Syntax   : Number of formulae    :    9 (   3 unit)
%            Number of atoms       :   20 (   4 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   14 (   3 ~  ;   0  |;   2  &)
%                                         (   7 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   1 constant; 0-2 arity)
%            Number of variables   :   19 (   0 singleton;  19 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable empty_set_ : Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable member_equal_1 : (forall B C : Universe, ((forall D : Universe, (member_ D B <-> member_ D C)) -> B = C)).
Variable difference_defn_2 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable empty_set_defn_3 : (forall B : Universe, ~(member_ B empty_set_)).
Variable equal_defn_4 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable equal_member_defn_5 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).
Variable subset_defn_6 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_7 : (forall B : Universe, subset_ B B).
Variable empty_defn_8 : (forall B : Universe, (empty_ B <-> (forall C : Universe, ~(member_ C B)))).

Theorem prove_th74_9 : (forall B : Universe, (difference_ B empty_set_) = B).
Proof.
  time hprover.
Qed.

End FOFProblem.
