(*
% File     : SET601+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : X ^ Y U Y ^ Z U Z ^ X = (X U Y) ^ (Y U Z) ^ (Z U X)
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : The intersection of X and the union of Y and the intersection 
%            of Y and the union of Z and the intersection of Z and X is the 
%            intersection of (the union of X and Y) and the intersection of 
%            (the union of Y and Z) and (the union of Z and X).
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (72) [TS89] 
% Status   : Theorem
% Rating   : 0.27 v3.1.0, 0.22 v2.7.0, 0.50 v2.6.0, 0.43 v2.5.0, 0.38 v2.4.0, 0.50 v2.3.0, 0.67 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   14 (   9 unit)
%            Number of atoms       :   24 (  10 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :   10 (   0 ~  ;   1  |;   2  &)
%                                         (   6 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    2 (   0 constant; 2-2 arity)
%            Number of variables   :   34 (   0 singleton;  34 !;   0 ?)
%            Maximal term depth    :    4 (   2 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.

Variable union_ : Universe -> Universe -> Universe.
Variable intersection_ : Universe -> Universe -> Universe.

Variable associativity_of_union_1 : (forall B C D : Universe, (union_ (union_ B C) D) = (union_ B (union_ C D))).
Variable idempotency_of_intersection_2 : (forall B : Universe, (intersection_ B B) = B).
Variable associativity_of_intersection_3 : (forall B C D : Universe, (intersection_ (intersection_ B C) D) = (intersection_ B (intersection_ C D))).
Variable union_intersection_4 : (forall B C : Universe, (union_ B (intersection_ B C)) = B).
Variable union_distributes_over_intersection_5 : (forall B C D : Universe, (union_ B (intersection_ C D)) = (intersection_ (union_ B C) (union_ B D))).
Variable union_defn_6 : (forall B C D : Universe, (member_ D (union_ B C) <-> (member_ D B \/ member_ D C))).
Variable intersection_defn_7 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable equal_defn_8 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable commutativity_of_union_9 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable commutativity_of_intersection_10 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable subset_defn_11 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_12 : (forall B : Universe, subset_ B B).
Variable equal_member_defn_13 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).

Theorem prove_th72_14 : (forall B C D : Universe, (union_ (union_ (intersection_ B C) (intersection_ C D)) (intersection_ D B)) = (intersection_ (intersection_ (union_ B C) (union_ C D)) (union_ D B))).
Proof.
  time hprover.
Qed.

End FOFProblem.
