(*
% File     : SET599+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : X \ Y (= X sym\ Y
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : The difference of X and Y is a subset of the symmetric 
%            difference of X and Y.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (58) [TS89] 
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.11 v2.7.0, 0.00 v2.5.0, 0.12 v2.4.0, 0.25 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0, 1.00 v1.0.0
% Syntax   : Number of formulae    :    9 (   6 unit)
%            Number of atoms       :   15 (   4 equality)
%            Maximal formula depth :    7 (   4 average)
%            Number of connectives :    7 (   1 ~  ;   0  |;   1  &)
%                                         (   4 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    3 (   0 constant; 2-2 arity)
%            Number of variables   :   20 (   0 singleton;  20 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.

Variable union_ : Universe -> Universe -> Universe.
Variable symmetric_difference_ : Universe -> Universe -> Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable symmetric_difference_defn_1 : (forall B C : Universe, (symmetric_difference_ B C) = (union_ (difference_ B C) (difference_ C B))).
Variable subset_of_union_2 : (forall B C : Universe, subset_ B (union_ B C)).
Variable difference_defn_3 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable subset_defn_4 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable commutativity_of_union_5 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable commutativity_of_symmetric_difference_6 : (forall B C : Universe, (symmetric_difference_ B C) = (symmetric_difference_ C B)).
Variable equal_member_defn_7 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).
Variable reflexivity_of_subset_8 : (forall B : Universe, subset_ B B).

Theorem prove_th58_9 : (forall B C : Universe, subset_ (difference_ B C) (symmetric_difference_ B C)).
Proof.
  time hprover.
Qed.

End FOFProblem.
