(*
% File     : SET592+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : If X (= Y and X (= Z and Y ^ Z = empty set, then X = empty set
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : If X is a subset of Y and X is a subset of Z and the 
%            intersection of Y and Z is the empty set, then X is the empty 
%            set.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (51) [TS89] 
% Status   : Theorem
% Rating   : 0.09 v3.1.0, 0.11 v2.7.0, 0.00 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0, 1.00 v1.0.0
% Syntax   : Number of formulae    :   11 (   3 unit)
%            Number of atoms       :   26 (   6 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   17 (   2 ~  ;   0  |;   5  &)
%                                         (   6 <=>;   4 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   1 constant; 0-2 arity)
%            Number of variables   :   24 (   0 singleton;  24 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable intersection_ : Universe -> Universe -> Universe.
Variable empty_set_ : Universe.

Variable subset_of_empty_set_is_empty_set_1 : (forall B : Universe, (subset_ B empty_set_ -> B = empty_set_)).
Variable intersection_of_subsets_2 : (forall B C D : Universe, ((subset_ B C /\ subset_ B D) -> subset_ B (intersection_ C D))).
Variable empty_set_defn_3 : (forall B : Universe, ~(member_ B empty_set_)).
Variable intersection_defn_4 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable subset_defn_5 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable equal_defn_6 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable commutativity_of_intersection_7 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable reflexivity_of_subset_8 : (forall B : Universe, subset_ B B).
Variable empty_defn_9 : (forall B : Universe, (empty_ B <-> (forall C : Universe, ~(member_ C B)))).
Variable equal_member_defn_10 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).

Theorem prove_th51_11 : (forall B C D : Universe, ((subset_ B C /\ (subset_ B D /\ (intersection_ C D) = empty_set_)) -> B = empty_set_)).
Proof.
  time hprover.
Qed.

End FOFProblem.
