(*
% File     : SET590+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : The difference of X and Y is a subset of X
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (49) [TS89] 
% Status   : Theorem
% Rating   : 0.00 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :    4 (   2 unit)
%            Number of atoms       :    8 (   0 equality)
%            Maximal formula depth :    7 (   4 average)
%            Number of connectives :    5 (   1 ~  ;   0  |;   1  &)
%                                         (   2 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    2 (   0 propositional; 2-2 arity)
%            Number of functors    :    1 (   0 constant; 2-2 arity)
%            Number of variables   :    9 (   0 singleton;   9 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.

Variable difference_ : Universe -> Universe -> Universe.

Variable difference_defn_1 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable subset_defn_2 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_3 : (forall B : Universe, subset_ B B).

Theorem prove_th49_4 : (forall B C : Universe, subset_ (difference_ B C) B).
Proof.
  time hprover.
Qed.

End FOFProblem.
