(*
% File     : SET589+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : If X (= Y and Z (= V, then X \ V (= Y \ Z
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : If X is a subset of Y and Z is a subset of V, then the 
%            difference of X and V is a subset of the difference of Y and Z.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (48) [TS89] 
% Status   : Theorem
% Rating   : 0.00 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.25 v1.0.0
% Syntax   : Number of formulae    :    7 (   1 unit)
%            Number of atoms       :   17 (   0 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   11 (   1 ~  ;   0  |;   3  &)
%                                         (   2 <=>;   5 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    2 (   0 propositional; 2-2 arity)
%            Number of functors    :    1 (   0 constant; 2-2 arity)
%            Number of variables   :   20 (   0 singleton;  20 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.

Variable difference_ : Universe -> Universe -> Universe.

Variable transitivity_of_subset_1 : (forall B C D : Universe, ((subset_ B C /\ subset_ C D) -> subset_ B D)).
Variable difference_subset1_2 : (forall B C D : Universe, (subset_ B C -> subset_ (difference_ B D) (difference_ C D))).
Variable difference_subset2_3 : (forall B C D : Universe, (subset_ B C -> subset_ (difference_ D C) (difference_ D B))).
Variable difference_defn_4 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable subset_defn_5 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_6 : (forall B : Universe, subset_ B B).

Theorem prove_th48_7 : (forall B C D E : Universe, ((subset_ B C /\ subset_ D E) -> subset_ (difference_ B E) (difference_ C D))).
Proof.
  time hprover.
Qed.

End FOFProblem.
