(*
% File     : SET587+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : X \ Y = the empty set iff X (= Y
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : The difference of X and Y is the empty set iff X is a subset of 
%            Y.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (45) [TS89] 
% Status   : Theorem
% Rating   : 0.45 v3.1.0, 0.33 v2.6.0, 0.29 v2.5.0, 0.12 v2.4.0, 0.25 v2.3.0, 0.00 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    9 (   2 unit)
%            Number of atoms       :   21 (   4 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   15 (   3 ~  ;   0  |;   2  &)
%                                         (   8 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-2 arity)
%            Number of functors    :    2 (   1 constant; 0-2 arity)
%            Number of variables   :   20 (   0 singleton;  20 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable empty_ : Universe -> Prop.

Variable empty_set_ : Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable member_equal_1 : (forall B C : Universe, ((forall D : Universe, (member_ D B <-> member_ D C)) -> B = C)).
Variable difference_defn_2 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable empty_set_defn_3 : (forall B : Universe, ~(member_ B empty_set_)).
Variable subset_defn_4 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable equal_defn_5 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable equal_member_defn_6 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).
Variable reflexivity_of_subset_7 : (forall B : Universe, subset_ B B).
Variable empty_defn_8 : (forall B : Universe, (empty_ B <-> (forall C : Universe, ~(member_ C B)))).

Theorem prove_difference_empty_set_9 : (forall B C : Universe, ((difference_ B C) = empty_set_ <-> subset_ B C)).
Proof.
  time hprover.
Qed.

End FOFProblem.
