(*
% File     : SET583+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : Extensionality
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (28) [TS89] 
% Status   : Theorem
% Rating   : 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0, 0.00 v1.0.0
% Syntax   : Number of formulae    :    4 (   1 unit)
%            Number of atoms       :   10 (   2 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :    6 (   0 ~  ;   0  |;   2  &)
%                                         (   2 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    8 (   0 singleton;   8 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.


Variable equal_defn_1 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable subset_defn_2 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_3 : (forall B : Universe, subset_ B B).

Theorem prove_extensionality_4 : (forall B C : Universe, ((subset_ B C /\ subset_ C B) -> B = C)).
Proof.
  time hprover.
Qed.

End FOFProblem.
