(*
% File     : SET582+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : If x not in X iff x in Y iff x in Z, then X = Y sym\ Z
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : If for every x : x is not in X iff x is in Y iff x is in Z, 
%            then X is the symmetric difference of Y and Z.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (25) [TS89] 
% Status   : Theorem
% Rating   : 0.73 v3.1.0, 0.78 v2.7.0, 1.00 v2.4.0, 0.75 v2.3.0, 0.67 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   11 (   4 unit)
%            Number of atoms       :   26 (   7 equality)
%            Maximal formula depth :    8 (   5 average)
%            Number of connectives :   17 (   2 ~  ;   1  |;   2  &)
%                                         (   9 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    3 (   0 constant; 2-2 arity)
%            Number of variables   :   28 (   0 singleton;  28 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.

Variable union_ : Universe -> Universe -> Universe.
Variable symmetric_difference_ : Universe -> Universe -> Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable member_equal_1 : (forall B C : Universe, ((forall D : Universe, (member_ D B <-> member_ D C)) -> B = C)).
Variable union_defn_2 : (forall B C D : Universe, (member_ D (union_ B C) <-> (member_ D B \/ member_ D C))).
Variable difference_defn_3 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable symmetric_difference_defn_4 : (forall B C : Universe, (symmetric_difference_ B C) = (union_ (difference_ B C) (difference_ C B))).
Variable equal_defn_5 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable commutativity_of_union_6 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable commutativity_of_symmetric_difference_7 : (forall B C : Universe, (symmetric_difference_ B C) = (symmetric_difference_ C B)).
Variable equal_member_defn_8 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).
Variable subset_defn_9 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_10 : (forall B : Universe, subset_ B B).

Theorem prove_th25_11 : (forall B C D : Universe, ((forall E : Universe, (~(member_ E B) <-> (member_ E C <-> member_ E D))) -> B = (symmetric_difference_ C D))).
Proof.
  time hprover.
Qed.

End FOFProblem.
