(*
% File     : SET580+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : x is in X sym\ Y iff x is in X iff x is not in Y
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : x is in the symmetric difference of X and Y iff it is not the 
%            case x is in X iff x is in Y.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (23) [TS89] 
% Status   : Theorem
% Rating   : 0.36 v3.1.0, 0.44 v2.7.0, 0.33 v2.6.0, 0.29 v2.5.0, 0.38 v2.4.0, 0.50 v2.3.0, 0.33 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    7 (   3 unit)
%            Number of atoms       :   15 (   4 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   10 (   2 ~  ;   1  |;   1  &)
%                                         (   6 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    2 (   0 propositional; 2-2 arity)
%            Number of functors    :    3 (   0 constant; 2-2 arity)
%            Number of variables   :   18 (   0 singleton;  18 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable member_ : Universe -> Universe -> Prop.

Variable union_ : Universe -> Universe -> Universe.
Variable symmetric_difference_ : Universe -> Universe -> Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable union_defn_1 : (forall B C D : Universe, (member_ D (union_ B C) <-> (member_ D B \/ member_ D C))).
Variable difference_defn_2 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable symmetric_difference_defn_3 : (forall B C : Universe, (symmetric_difference_ B C) = (union_ (difference_ B C) (difference_ C B))).
Variable commutativity_of_union_4 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable commutativity_of_symmetric_difference_5 : (forall B C : Universe, (symmetric_difference_ B C) = (symmetric_difference_ C B)).
Variable equal_member_defn_6 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).

Theorem prove_th23_7 : (forall B C D : Universe, (member_ B (symmetric_difference_ C D) <-> ~((member_ B C <-> member_ B D)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
