(*
% File     : SET011+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : X \ (X \ Y) = X ^ Y
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : The difference of X and (the difference of X and Y) is the 
%            intersection of X and Y.
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (82) [TS89] 
% Status   : Theorem
% Rating   : 0.55 v3.1.0, 0.67 v2.7.0, 0.50 v2.6.0, 0.57 v2.5.0, 0.75 v2.4.0, 0.25 v2.3.0, 0.00 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    8 (   3 unit)
%            Number of atoms       :   18 (   4 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :   11 (   1 ~  ;   0  |;   3  &)
%                                         (   6 <=>;   1 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    2 (   0 constant; 2-2 arity)
%            Number of variables   :   19 (   0 singleton;  19 !;   0 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.

Variable intersection_ : Universe -> Universe -> Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable intersection_defn_1 : (forall B C D : Universe, (member_ D (intersection_ B C) <-> (member_ D B /\ member_ D C))).
Variable difference_defn_2 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable equal_defn_3 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable commutativity_of_intersection_4 : (forall B C : Universe, (intersection_ B C) = (intersection_ C B)).
Variable subset_defn_5 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_6 : (forall B : Universe, subset_ B B).
Variable equal_member_defn_7 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).

Theorem prove_difference_difference_intersection_8 : (forall B C : Universe, (difference_ B (difference_ B C)) = (intersection_ B C)).
Proof.
  time hprover.
Qed.

End FOFProblem.
