(*
% File     : SET009+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : If X is a subset of Y, then Z \ Y is a subset of Z \ X
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : If X is a subset of Y, then the difference of Z and Y is a 
%            subset of the difference of Z and X. 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (47) [TS89]
% Status   : Theorem
% Rating   : 0.00 v3.1.0, 0.25 v2.7.0, 0.00 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    4 (   1 unit)
%            Number of atoms       :    9 (   0 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :    6 (   1 ~  ;   0  |;   1  &)
%                                         (   2 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    2 (   0 propositional; 2-2 arity)
%            Number of functors    :    1 (   0 constant; 2-2 arity)
%            Number of variables   :   10 (   0 singleton;  10 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.

Variable difference_ : Universe -> Universe -> Universe.

Variable difference_defn_1 : (forall B C D : Universe, (member_ D (difference_ B C) <-> (member_ D B /\ ~(member_ D C)))).
Variable subset_defn_2 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_3 : (forall B : Universe, subset_ B B).

Theorem prove_subset_difference_4 : (forall B C D : Universe, (subset_ B C -> subset_ (difference_ D C) (difference_ D B))).
Proof.
  time hprover.
Qed.

End FOFProblem.
