(*
% File     : SET002+3 : ILTP v1.1.2
% Domain   : Set Theory (Boolean properties)
% Problem  : Idempotency of union
% Version  : [Try89] axioms : Reduced > Incomplete.
% English  : 
% Refs     : [ILF] The ILF Group (1998), The ILF System: A Tool for the Int
%          : [Try89] Trybulec (1989), Tarski Grothendieck Set Theory
%          : [TS89]  Trybulec & Swieczkowska (1989), Boolean Properties of
% Source   : [ILF]
% Names    : BOOLE (62) [TS89] 
% Status   : Theorem
% Rating   : 0.09 v3.1.0, 0.11 v2.7.0, 0.00 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    8 (   3 unit)
%            Number of atoms       :   17 (   5 equality)
%            Maximal formula depth :    6 (   4 average)
%            Number of connectives :    9 (   0 ~  ;   1  |;   1  &)
%                                         (   5 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    1 (   0 constant; 2-2 arity)
%            Number of variables   :   17 (   0 singleton;  17 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.

Variable union_ : Universe -> Universe -> Universe.

Variable subset_union_1 : (forall B C : Universe, (subset_ B C -> (union_ B C) = C)).
Variable union_defn_2 : (forall B C D : Universe, (member_ D (union_ B C) <-> (member_ D B \/ member_ D C))).
Variable equal_defn_3 : (forall B C : Universe, (B = C <-> (subset_ B C /\ subset_ C B))).
Variable commutativity_of_union_4 : (forall B C : Universe, (union_ B C) = (union_ C B)).
Variable subset_defn_5 : (forall B C : Universe, (subset_ B C <-> (forall D : Universe, (member_ D B -> member_ D C)))).
Variable reflexivity_of_subset_6 : (forall B : Universe, subset_ B B).
Variable equal_member_defn_7 : (forall B C : Universe, (B = C <-> (forall D : Universe, (member_ D B <-> member_ D C)))).

Theorem prove_idempotency_of_union_8 : (forall B : Universe, (union_ B B) = B).
Proof.
  time hprover.
Qed.

End FOFProblem.
