(*
% File     : PUZ047+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Taking the wolf, goat, and cabbage across river
% Version  : Especial.
% English  : 
% Refs     : [And97] Andrews (1994), Email to G. Sutcliffe
% Source   : [And97]
% Names    : THM100 [And97]
% Status   : Theorem
% Rating   : 0.00 v2.5.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :   30 (   0 equality)
%            Maximal formula depth :   18 (  18 average)
%            Number of connectives :   29 (   0 ~  ;   0  |;  14  &)
%                                         (   0 <=>;  15 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    1 (   0 propositional; 5-5 arity)
%            Number of functors    :    7 (   3 constant; 0-1 arity)
%            Number of variables   :   19 (   0 singleton;  18 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable p_ : Universe -> Universe -> Universe -> Universe -> Universe -> Prop.

Variable take_wolf_ : Universe -> Universe.
Variable take_goat_ : Universe -> Universe.
Variable take_cabbage_ : Universe -> Universe.
Variable start_ : Universe.
Variable south_ : Universe.
Variable north_ : Universe.
Variable go_alone_ : Universe -> Universe.


Theorem thm100_1 : ((p_ south_ south_ south_ south_ start_ /\ ((forall T : Universe, (p_ south_ north_ south_ north_ T -> p_ north_ north_ south_ north_ (go_alone_ T))) /\ ((forall T1 : Universe, (p_ north_ north_ south_ north_ T1 -> p_ south_ north_ south_ north_ (go_alone_ T1))) /\ ((forall T2 : Universe, (p_ south_ south_ north_ south_ T2 -> p_ north_ south_ north_ south_ (go_alone_ T2))) /\ ((forall T3 : Universe, (p_ north_ south_ north_ south_ T3 -> p_ south_ south_ north_ south_ (go_alone_ T3))) /\ ((forall T4 : Universe, (p_ south_ south_ south_ north_ T4 -> p_ north_ north_ south_ north_ (take_wolf_ T4))) /\ ((forall T5 : Universe, (p_ north_ north_ south_ north_ T5 -> p_ south_ south_ south_ north_ (take_wolf_ T5))) /\ ((forall T6 : Universe, (p_ south_ south_ north_ south_ T6 -> p_ north_ north_ north_ south_ (take_wolf_ T6))) /\ ((forall T7 : Universe, (p_ north_ north_ north_ south_ T7 -> p_ south_ south_ north_ south_ (take_wolf_ T7))) /\ ((forall X Y U : Universe, (p_ south_ X south_ Y U -> p_ north_ X north_ Y (take_goat_ U))) /\ ((forall X1 Y1 V : Universe, (p_ north_ X1 north_ Y1 V -> p_ south_ X1 south_ Y1 (take_goat_ V))) /\ ((forall T8 : Universe, (p_ south_ north_ south_ south_ T8 -> p_ north_ north_ south_ north_ (take_cabbage_ T8))) /\ ((forall T9 : Universe, (p_ north_ north_ south_ north_ T9 -> p_ south_ north_ south_ south_ (take_cabbage_ T9))) /\ ((forall U1 : Universe, (p_ south_ south_ north_ south_ U1 -> p_ north_ south_ north_ north_ (take_cabbage_ U1))) /\ (forall V1 : Universe, (p_ north_ south_ north_ north_ V1 -> p_ south_ south_ north_ south_ (take_cabbage_ V1))))))))))))))))) -> (exists Z : Universe, p_ north_ north_ north_ north_ Z)).
Proof.
  time hprover.
Qed.

End FOFProblem.
