(*
% File     : PUZ005+1 : ILTP v1.1.2
% Domain   : Puzzles
% Problem  : The Lion and the Unicorn
% Version  : [OS95] axioms.
% English  : 
% Refs     : [Wei94] Weidenbach (1994), Email to G. Sutcliffe
%          : [Wei93] Weidenbach (1993), Extending the Resolution Method wit
%          : [Smu78] Smullyan (1978), What is the Name of This Book? The Ri
%          : [OS85]  Ohlbach & Schmidt-Schauss M. (1985), The Lion and the
% Source   : [Wei94]
% Names    : 
% Status   : Theorem
% Rating   : 0.00 v2.2.1
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   46 (   7 unit)
%            Number of atoms       :  110 (   0 equality)
%            Maximal formula depth :    8 (   4 average)
%            Number of connectives :   84 (  20 ~  ;   0  |;  10  &)
%                                         (   0 <=>;  54 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   11 (   0 propositional; 1-3 arity)
%            Number of functors    :   10 (   9 constant; 0-1 arity)
%            Number of variables   :   47 (   0 singleton;  46 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : This problem can be easily solved by sorted theorem provers which
%            are able to represent the one place predicates as sorts, but is 
%            very hard for standard first-order provers. It can be further 
%            complicated by iterating the 'yesterday' nesting in the theorem, 
%            e.g.  the next iteration would be: -(exists x (day(x) & 
%            lies(a_lion,x,yesterday(yesterday(x))) & lies(a_unicorn,x,
%            yesterday(yesterday(x))))).
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable wednesday_ : Universe -> Prop.
Variable unicorn_lies_ : Universe -> Prop.
Variable tuesday_ : Universe -> Prop.
Variable thursday_ : Universe -> Prop.
Variable sunday_ : Universe -> Prop.
Variable saturday_ : Universe -> Prop.
Variable monday_ : Universe -> Prop.
Variable lion_lies_ : Universe -> Prop.
Variable lies_on_one_of_ : Universe -> Universe -> Universe -> Prop.
Variable friday_ : Universe -> Prop.
Variable day_ : Universe -> Prop.

Variable yesterday_ : Universe -> Universe.
Variable a_wednesday_ : Universe.
Variable a_unicorn_ : Universe.
Variable a_tuesday_ : Universe.
Variable a_thursday_ : Universe.
Variable a_sunday_ : Universe.
Variable a_saturday_ : Universe.
Variable a_monday_ : Universe.
Variable a_lion_ : Universe.
Variable a_friday_ : Universe.

Variable monday_1 : monday_ a_monday_.
Variable tuesday_2 : tuesday_ a_tuesday_.
Variable wednesday_3 : wednesday_ a_wednesday_.
Variable thursday_4 : thursday_ a_thursday_.
Variable friday_5 : friday_ a_friday_.
Variable saturday_6 : saturday_ a_saturday_.
Variable sunday_7 : sunday_ a_sunday_.
Variable monday_is_a_day_8 : (forall X : Universe, (monday_ X -> day_ X)).
Variable tuesday_is_a_day_9 : (forall X : Universe, (tuesday_ X -> day_ X)).
Variable wednesday_is_a_day_10 : (forall X : Universe, (wednesday_ X -> day_ X)).
Variable thursday_is_a_day_11 : (forall X : Universe, (thursday_ X -> day_ X)).
Variable friday_is_a_day_12 : (forall X : Universe, (friday_ X -> day_ X)).
Variable saturday_is_a_day_13 : (forall X : Universe, (saturday_ X -> day_ X)).
Variable sunday_is_a_day_14 : (forall X : Universe, (sunday_ X -> day_ X)).
Variable monday_follows_sunday_15 : (forall X : Universe, (monday_ X -> sunday_ (yesterday_ X))).
Variable tuesday_follows_monday_16 : (forall X : Universe, (tuesday_ X -> monday_ (yesterday_ X))).
Variable wednesday_follows_tuesday_17 : (forall X : Universe, (wednesday_ X -> tuesday_ (yesterday_ X))).
Variable thursday_follows_wednesday_18 : (forall X : Universe, (thursday_ X -> wednesday_ (yesterday_ X))).
Variable friday_follows_thursday_19 : (forall X : Universe, (friday_ X -> thursday_ (yesterday_ X))).
Variable saturday_follows_friday_20 : (forall X : Universe, (saturday_ X -> friday_ (yesterday_ X))).
Variable sunday_follows_saturday_21 : (forall X : Universe, (sunday_ X -> saturday_ (yesterday_ X))).
Variable lion_lies_monday_22 : (forall X : Universe, (monday_ X -> lion_lies_ X)).
Variable lion_lies_tuesday_23 : (forall X : Universe, (tuesday_ X -> lion_lies_ X)).
Variable lion_lies_wednesday_24 : (forall X : Universe, (wednesday_ X -> lion_lies_ X)).
Variable lion_does_not_lie_thursday_25 : (forall X : Universe, (thursday_ X -> ~(lion_lies_ X))).
Variable lion_does_not_lie_friday_26 : (forall X : Universe, (friday_ X -> ~(lion_lies_ X))).
Variable lion_does_not_lie_saturday_27 : (forall X : Universe, (saturday_ X -> ~(lion_lies_ X))).
Variable lion_does_not_lie_sunday_28 : (forall X : Universe, (sunday_ X -> ~(lion_lies_ X))).
Variable unicorn_does_not_lie_monday_29 : (forall X : Universe, (monday_ X -> ~(unicorn_lies_ X))).
Variable unicorn_does_not_lie_tuesday_30 : (forall X : Universe, (tuesday_ X -> ~(unicorn_lies_ X))).
Variable unicorn_does_not_lie_wednesday_31 : (forall X : Universe, (wednesday_ X -> ~(unicorn_lies_ X))).
Variable unicorn_lies_thursday_32 : (forall X : Universe, (thursday_ X -> unicorn_lies_ X)).
Variable unicorn_lies_friday_33 : (forall X : Universe, (friday_ X -> unicorn_lies_ X)).
Variable unicorn_lies_saturday_34 : (forall X : Universe, (saturday_ X -> unicorn_lies_ X)).
Variable unicorn_does_not_lie_sunday_35 : (forall X : Universe, (sunday_ X -> ~(unicorn_lies_ X))).
Variable lion_lies_on_a_day_36 : (forall X : Universe, (lion_lies_ X -> day_ X)).
Variable unicorn_lies_on_a_day_37 : (forall X : Universe, (unicorn_lies_ X -> day_ X)).
Variable lion_lies_on_this_day_38 : (forall X : Universe, (day_ X -> (forall Y : Universe, (day_ Y -> ((lion_lies_ X /\ lies_on_one_of_ a_lion_ X Y) -> ~(lion_lies_ Y)))))).
Variable lion_lies_on_other_day_39 : (forall X : Universe, (day_ X -> (forall Y : Universe, (day_ Y -> ((~(lion_lies_ X) /\ lies_on_one_of_ a_lion_ X Y) -> lion_lies_ Y))))).
Variable lion_lies_on_neither_40 : (forall X : Universe, (day_ X -> (forall Y : Universe, (day_ Y -> ((~(lion_lies_ X) /\ ~(lies_on_one_of_ a_lion_ X Y)) -> ~(lion_lies_ Y)))))).
Variable lion_lies_on_both_41 : (forall X : Universe, (day_ X -> (forall Y : Universe, (day_ Y -> ((lion_lies_ X /\ ~(lies_on_one_of_ a_lion_ X Y)) -> lion_lies_ Y))))).
Variable unicorn_lies_on_this_day_42 : (forall X : Universe, (day_ X -> (forall Y : Universe, (day_ Y -> ((unicorn_lies_ X /\ lies_on_one_of_ a_unicorn_ X Y) -> ~(unicorn_lies_ Y)))))).
Variable unicorn_lies_on_other_day_43 : (forall X : Universe, (day_ X -> (forall Y : Universe, (day_ Y -> ((~(unicorn_lies_ X) /\ lies_on_one_of_ a_unicorn_ X Y) -> unicorn_lies_ Y))))).
Variable unicorn_lies_on_neither_44 : (forall X : Universe, (day_ X -> (forall Y : Universe, (day_ Y -> ((~(unicorn_lies_ X) /\ ~(lies_on_one_of_ a_unicorn_ X Y)) -> ~(unicorn_lies_ Y)))))).
Variable unicorn_lies_on_both_45 : (forall X : Universe, (day_ X -> (forall Y : Universe, (day_ Y -> ((unicorn_lies_ X /\ ~(lies_on_one_of_ a_unicorn_ X Y)) -> unicorn_lies_ Y))))).

Theorem prove_there_are_close_lying_days_46 : (exists X : Universe, (day_ X /\ (lies_on_one_of_ a_lion_ X (yesterday_ X) /\ lies_on_one_of_ a_unicorn_ X (yesterday_ X)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
