(*
% File     : PUZ001+1 : ILTP v1.1.2
% Domain   : Puzzles
% Problem  : Dreadbury Mansion
% Version  : Especial.
%            Theorem formulation : Reduced > Complete.
% English  : Someone who lives in Dreadbury Mansion killed Aunt Agatha. 
%            Agatha, the butler, and Charles live in Dreadbury Mansion, 
%            and are the only people who live therein. A killer always 
%            hates his victim, and is never richer than his victim. 
%            Charles hates no one that Aunt Agatha hates. Agatha hates 
%            everyone except the butler. The butler hates everyone not 
%            richer than Aunt Agatha. The butler hates everyone Aunt 
%            Agatha hates. No one hates everyone. Agatha is not the 
%            butler. Therefore : Agatha killed herself.
% Refs     : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 55 [Pel86]
% Status   : Theorem
% Rating   : 0.22 v3.1.0, 0.17 v2.7.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   14 (   6 unit)
%            Number of atoms       :   24 (   5 equality)
%            Maximal formula depth :    5 (   3 average)
%            Number of connectives :   16 (   6 ~  ;   2  |;   1  &)
%                                         (   0 <=>;   7 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    5 (   0 propositional; 1-2 arity)
%            Number of functors    :    3 (   3 constant; 0-0 arity)
%            Number of variables   :   12 (   0 singleton;  10 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : Modified by Geoff Sutcliffe.
%          : Also known as Who killed Aunt Agatha
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable richer_ : Universe -> Universe -> Prop.
Variable lives_ : Universe -> Prop.
Variable killed_ : Universe -> Universe -> Prop.
Variable hates_ : Universe -> Universe -> Prop.

Variable charles_ : Universe.
Variable butler_ : Universe.
Variable agatha_ : Universe.

Variable pel55_1_1 : (exists X : Universe, (lives_ X /\ killed_ X agatha_)).
Variable pel55_2_1_2 : lives_ agatha_.
Variable pel55_2_2_3 : lives_ butler_.
Variable pel55_2_3_4 : lives_ charles_.
Variable pel55_3_5 : (forall X : Universe, (lives_ X -> (X = agatha_ \/ (X = butler_ \/ X = charles_)))).
Variable pel55_4_6 : (forall X Y : Universe, (killed_ X Y -> hates_ X Y)).
Variable pel55_5_7 : (forall X Y : Universe, (killed_ X Y -> ~(richer_ X Y))).
Variable pel55_6_8 : (forall X : Universe, (hates_ agatha_ X -> ~(hates_ charles_ X))).
Variable pel55_7_9 : (forall X : Universe, (X <> butler_ -> hates_ agatha_ X)).
Variable pel55_8_10 : (forall X : Universe, (~(richer_ X agatha_) -> hates_ butler_ X)).
Variable pel55_9_11 : (forall X : Universe, (hates_ agatha_ X -> hates_ butler_ X)).
Variable pel55_10_12 : (forall X : Universe, (exists Y : Universe, ~(hates_ X Y))).
Variable pel55_11_13 : agatha_ <> butler_.

Theorem pel55_14 : killed_ agatha_ agatha_.
Proof.
  time hprover.
Qed.

End FOFProblem.
