(*
% File     : PLA026+1 : ILTP v1.1.2
% Domain   : Planning
% Problem  : Blocks 3/2/1, 5/4 => 5/3, 1, 4/2
% Version  : [Bau99] axioms.
% English  :
% Refs     : [Bau99] Baumgartner (1999), FTP'2000 - Problem Sets
%            [KS96]  Kautz & Selman (1996), Pushing the Envelope: Planning,
%            [KS92]  Kautz & Selman (1992), Planning as Satisfiability
% Source   : [Bau99]
% Names    : medium [Bau99]
% Status   : CounterSatisfiable
% Rating   : 0.33 v3.1.0, 0.67 v2.5.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   69 (  40 unit)
%            Number of atoms       :  191 (   0 equality)
%            Maximal formula depth :   10 (   4 average)
%            Number of connectives :  147 (  25 ~  ;  15  |;  50  &)
%                                         (   0 <=>;  57 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   12 (   0 propositional; 1-3 arity)
%            Number of functors    :    8 (   7 constant; 0-1 arity)
%            Number of variables   :   70 (   0 singleton;  70 !;   0 ?)
%            Maximal term depth    :    5 (   1 average)
% Comments :
% Bugfixes : v2.5.0 - Combined multiple conjecture formulae.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable time_ : Universe -> Prop.
Variable source_ : Universe -> Universe -> Prop.
Variable on_ : Universe -> Universe -> Universe -> Prop.
Variable object_ : Universe -> Universe -> Prop.
Variable nonfixed_ : Universe -> Prop.
Variable neq_ : Universe -> Universe -> Prop.
Variable goal_time_ : Universe -> Prop.
Variable fixed_ : Universe -> Prop.
Variable different_ : Universe -> Universe -> Prop.
Variable destination_ : Universe -> Universe -> Prop.
Variable clear_ : Universe -> Universe -> Prop.
Variable a_block_ : Universe -> Prop.

Variable time_0_ : Universe.
Variable table_ : Universe.
Variable s_ : Universe -> Universe.
Variable block_5_ : Universe.
Variable block_4_ : Universe.
Variable block_3_ : Universe.
Variable block_2_ : Universe.
Variable block_1_ : Universe.

Variable place_object_block_on_destination_1 : (forall I X : Universe, (nonfixed_ X -> (forall Z : Universe, ((a_block_ Z /\ neq_ X Z) -> ((time_ I /\ (object_ X I /\ destination_ Z I)) -> on_ X Z (s_ I)))))).
Variable remove_object_block_from_source_2 : (forall I X : Universe, (nonfixed_ X -> (forall Y : Universe, ((a_block_ Y /\ neq_ X Y) -> ((time_ I /\ (object_ X I /\ source_ Y I)) -> ~(on_ X Y (s_ I))))))).
Variable clear_source_after_removal_3 : (forall I Y : Universe, (nonfixed_ Y -> ((time_ I /\ source_ Y I) -> clear_ Y (s_ I)))).
Variable not_clear_destination_after_placement_4 : (forall I Z : Universe, (nonfixed_ Z -> ((time_ I /\ destination_ Z I) -> ~(clear_ Z (s_ I))))).
Variable object_block_on_source_5 : (forall I X : Universe, (nonfixed_ X -> (forall Y : Universe, ((a_block_ Y /\ neq_ X Y) -> ((object_ X I /\ source_ Y I) -> on_ X Y I))))).
Variable object_block_is_clear_6 : (forall I X : Universe, (nonfixed_ X -> (object_ X I -> clear_ X I))).
Variable destination_block_is_clear_7 : (forall I Z : Universe, (nonfixed_ Z -> (destination_ Z I -> clear_ Z I))).
Variable non_destination_remains_clear_8 : (forall I W : Universe, (nonfixed_ W -> ((time_ I /\ (~(destination_ W I) /\ clear_ W I)) -> clear_ W (s_ I)))).
Variable non_object_remains_on_9 : (forall I V : Universe, (nonfixed_ V -> (forall W : Universe, ((a_block_ W /\ neq_ V W) -> ((time_ I /\ (~(object_ V I) /\ on_ V W I)) -> on_ V W (s_ I)))))).
Variable non_source_remains_not_clear_10 : (forall I W : Universe, (nonfixed_ W -> ((time_ I /\ (~(source_ W I) /\ ~(clear_ W I))) -> ~(clear_ W (s_ I))))).
Variable non_object_remains_not_on_11 : (forall I V : Universe, (nonfixed_ V -> (forall W : Universe, ((a_block_ W /\ neq_ V W) -> ((time_ I /\ (~(object_ V I) /\ ~(on_ V W I))) -> ~(on_ V W (s_ I))))))).
Variable non_destination_remains_not_on_12 : (forall I V : Universe, (nonfixed_ V -> (forall W : Universe, ((a_block_ W /\ neq_ V W) -> ((time_ I /\ (~(destination_ W I) /\ ~(on_ V W I))) -> ~(on_ V W (s_ I))))))).
Variable only_one_object_block_13 : (forall I X1 : Universe, (nonfixed_ X1 -> (forall X2 : Universe, ((a_block_ X2 /\ neq_ X1 X2) -> ~((object_ X1 I /\ object_ X2 I)))))).
Variable only_one_source_block_14 : (forall I Y1 : Universe, (a_block_ Y1 -> (forall Y2 : Universe, ((a_block_ Y2 /\ neq_ Y1 Y2) -> ~((source_ Y1 I /\ source_ Y2 I)))))).
Variable only_one_destination_block_15 : (forall I Z1 : Universe, (a_block_ Z1 -> (forall Z2 : Universe, ((a_block_ Z2 /\ neq_ Z1 Z2) -> ~((destination_ Z1 I /\ destination_ Z2 I)))))).
Variable object_is_not_source_16 : (forall I X : Universe, (nonfixed_ X -> ~((object_ X I /\ source_ X I)))).
Variable object_is_not_destination_17 : (forall I X : Universe, (nonfixed_ X -> ~((object_ X I /\ destination_ X I)))).
Variable source_is_not_destination_18 : (forall I Y : Universe, (a_block_ Y -> ~((source_ Y I /\ destination_ Y I)))).
Variable not_on_each_other_19 : (forall I X : Universe, (a_block_ X -> (forall Y : Universe, ((a_block_ Y /\ neq_ X Y) -> ~((on_ X Y I /\ on_ Y X I)))))).
Variable not_on_self_20 : (forall I X : Universe, (a_block_ X -> ~(on_ X X I))).
Variable only_one_on_21 : (forall I X : Universe, (nonfixed_ X -> (forall Y : Universe, ((nonfixed_ Y /\ neq_ X Y) -> (forall Z : Universe, ((nonfixed_ Z /\ (neq_ X Z /\ neq_ Y Z)) -> ~((on_ X Y I /\ on_ Z Y I)))))))).
Variable only_on_one_thing_22 : (forall I X : Universe, (nonfixed_ X -> (forall Y : Universe, ((a_block_ Y /\ neq_ X Y) -> (forall Z : Universe, ((a_block_ Z /\ (neq_ X Z /\ neq_ Y Z)) -> ~((on_ X Y I /\ on_ X Z I)))))))).
Variable not_clear_if_something_on_23 : (forall I X : Universe, (nonfixed_ X -> (forall Y : Universe, (nonfixed_ Y -> ~((on_ X Y I /\ clear_ Y I)))))).
Variable fixed_not_on_anything_24 : (forall I X : Universe, (a_block_ X -> (forall Y : Universe, (fixed_ Y -> ~(on_ Y X I))))).
Variable different_not_equal_25 : (forall Y X : Universe, ((different_ X Y \/ different_ Y X) -> neq_ X Y)).
Variable block_1_not_block_2_26 : different_ block_1_ block_2_.
Variable block_1_not_block_3_27 : different_ block_1_ block_3_.
Variable block_1_not_block_4_28 : different_ block_1_ block_4_.
Variable block_1_not_block_5_29 : different_ block_1_ block_5_.
Variable block_2_not_block_3_30 : different_ block_2_ block_3_.
Variable block_2_not_block_4_31 : different_ block_2_ block_4_.
Variable block_2_not_block_5_32 : different_ block_2_ block_5_.
Variable block_3_not_block_4_33 : different_ block_3_ block_4_.
Variable block_3_not_block_5_34 : different_ block_3_ block_5_.
Variable block_4_not_block_5_35 : different_ block_4_ block_5_.
Variable block_1_not_table_36 : different_ block_1_ table_.
Variable block_2_not_table_37 : different_ block_2_ table_.
Variable block_3_not_table_38 : different_ block_3_ table_.
Variable block_4_not_table_39 : different_ block_4_ table_.
Variable block_5_not_table_40 : different_ block_5_ table_.
Variable block_1_41 : a_block_ block_1_.
Variable block_2_42 : a_block_ block_2_.
Variable block_3_43 : a_block_ block_3_.
Variable block_4_44 : a_block_ block_4_.
Variable block_5_45 : a_block_ block_5_.
Variable table_46 : a_block_ table_.
Variable fixed_table_47 : fixed_ table_.
Variable nonfixed_block_1_48 : nonfixed_ block_1_.
Variable nonfixed_block_2_49 : nonfixed_ block_2_.
Variable nonfixed_block_3_50 : nonfixed_ block_3_.
Variable nonfixed_block_4_51 : nonfixed_ block_4_.
Variable nonfixed_block_5_52 : nonfixed_ block_5_.
Variable time_0_53 : time_ time_0_.
Variable time_1_54 : time_ (s_ time_0_).
Variable time_2_55 : time_ (s_ (s_ time_0_)).
Variable time_3_56 : time_ (s_ (s_ (s_ time_0_))).
Variable time_4_57 : time_ (s_ (s_ (s_ (s_ time_0_)))).
Variable some_source_58 : (forall I : Universe, (time_ I -> (source_ block_1_ I \/ (source_ block_2_ I \/ (source_ block_3_ I \/ (source_ block_4_ I \/ (source_ block_5_ I \/ source_ table_ I))))))).
Variable some_destination_59 : (forall I : Universe, (time_ I -> (destination_ block_1_ I \/ (destination_ block_2_ I \/ (destination_ block_3_ I \/ (destination_ block_4_ I \/ (destination_ block_5_ I \/ destination_ table_ I))))))).
Variable some_object_60 : (forall I : Universe, (time_ I -> (object_ block_1_ I \/ (object_ block_2_ I \/ (object_ block_3_ I \/ (object_ block_4_ I \/ object_ block_5_ I)))))).
Variable initial_3_on_2_61 : on_ block_3_ block_2_ time_0_.
Variable initial_clear_3_62 : clear_ block_3_ time_0_.
Variable initial_2_on_1_63 : on_ block_2_ block_1_ time_0_.
Variable initial_1_on_table_64 : on_ block_1_ table_ time_0_.
Variable initial_5_on_4_65 : on_ block_5_ block_4_ time_0_.
Variable initial_clear_5_66 : clear_ block_5_ time_0_.
Variable initial_4_on_table_67 : on_ block_4_ table_ time_0_.
Variable goal_time_4_68 : goal_time_ (s_ (s_ (s_ (s_ time_0_)))).

Theorem goal_state_69 : (forall S : Universe, (goal_time_ S -> (on_ block_5_ block_3_ S /\ (clear_ block_5_ S /\ (on_ block_3_ table_ S /\ (on_ block_1_ table_ S /\ (clear_ block_1_ S /\ (on_ block_4_ block_2_ S /\ (clear_ block_4_ S /\ on_ block_2_ table_ S))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
