(*
% File     : NLP117+1 : ILTP v1.1.2
% Domain   : Natural Language Processing
% Problem  : An old dirty white Chevy, problem 4
% Version  : [Bos00b] axioms.
% English  : Eliminating logically equivalent interpretations in the statement
%            An old dirty white chevy barrels down a lonely street in 
%            hollywood.
% Refs     : [Bos00a] Bos (2000), DORIS: Discourse Oriented Representation a
%            [Bos00b] Bos (2000), Applied Theorem Proving - Natural Language
% Source   : [Bos00b]
% Names    : doris094 [Bos00b]
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.67 v2.7.0, 0.33 v2.6.0, 0.00 v2.4.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :   68 (   0 equality)
%            Maximal formula depth :   27 (  27 average)
%            Number of connectives :   69 (   2 ~  ;   0  |;  65  &)
%                                         (   0 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   17 (   0 propositional; 1-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   24 (   0 singleton;   0 !;  24 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable white_ : Universe -> Universe -> Prop.
Variable street_ : Universe -> Universe -> Prop.
Variable present_ : Universe -> Universe -> Prop.
Variable placename_ : Universe -> Universe -> Prop.
Variable old_ : Universe -> Universe -> Prop.
Variable of_ : Universe -> Universe -> Universe -> Prop.
Variable lonely_ : Universe -> Universe -> Prop.
Variable in_ : Universe -> Universe -> Universe -> Prop.
Variable hollywood_placename_ : Universe -> Universe -> Prop.
Variable event_ : Universe -> Universe -> Prop.
Variable down_ : Universe -> Universe -> Universe -> Prop.
Variable dirty_ : Universe -> Universe -> Prop.
Variable city_ : Universe -> Universe -> Prop.
Variable chevy_ : Universe -> Universe -> Prop.
Variable barrel_ : Universe -> Universe -> Prop.
Variable agent_ : Universe -> Universe -> Universe -> Prop.
Variable actual_world_ : Universe -> Prop.



Theorem co1_1 : ~(~((((exists U : Universe, (actual_world_ U /\ (exists V W X Y Z : Universe, (of_ U W V /\ (city_ U V /\ (hollywood_placename_ U W /\ (placename_ U W /\ (chevy_ U X /\ (white_ U X /\ (dirty_ U X /\ (old_ U X /\ (street_ U Y /\ (lonely_ U Y /\ (event_ U Z /\ (agent_ U Z X /\ (present_ U Z /\ (barrel_ U Z /\ (down_ U Z Y /\ in_ U Z V)))))))))))))))))) -> (exists X1 : Universe, (actual_world_ X1 /\ (exists X2 X3 X4 X5 X6 : Universe, (of_ X1 X3 X2 /\ (city_ X1 X2 /\ (hollywood_placename_ X1 X3 /\ (placename_ X1 X3 /\ (street_ X1 X4 /\ (lonely_ X1 X4 /\ (chevy_ X1 X5 /\ (white_ X1 X5 /\ (dirty_ X1 X5 /\ (old_ X1 X5 /\ (event_ X1 X6 /\ (agent_ X1 X6 X5 /\ (present_ X1 X6 /\ (barrel_ X1 X6 /\ (down_ X1 X6 X4 /\ in_ X1 X6 X2))))))))))))))))))) /\ ((exists X1 : Universe, (actual_world_ X1 /\ (exists X2 X3 X4 X5 X6 : Universe, (of_ X1 X3 X2 /\ (city_ X1 X2 /\ (hollywood_placename_ X1 X3 /\ (placename_ X1 X3 /\ (street_ X1 X4 /\ (lonely_ X1 X4 /\ (chevy_ X1 X5 /\ (white_ X1 X5 /\ (dirty_ X1 X5 /\ (old_ X1 X5 /\ (event_ X1 X6 /\ (agent_ X1 X6 X5 /\ (present_ X1 X6 /\ (barrel_ X1 X6 /\ (down_ X1 X6 X4 /\ in_ X1 X6 X2)))))))))))))))))) -> (exists U : Universe, (actual_world_ U /\ (exists V W X Y Z : Universe, (of_ U W V /\ (city_ U V /\ (hollywood_placename_ U W /\ (placename_ U W /\ (chevy_ U X /\ (white_ U X /\ (dirty_ U X /\ (old_ U X /\ (street_ U Y /\ (lonely_ U Y /\ (event_ U Z /\ (agent_ U Z X /\ (present_ U Z /\ (barrel_ U Z /\ (down_ U Z Y /\ in_ U Z V)))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
