(*
% File     : NLP102+1 : ILTP v1.1.2
% Domain   : Natural Language Processing
% Problem  : Every customer in a restaurant, problem 9
% Version  : [Bos00b] axioms.
% English  : Eliminating logically equivalent interpretations in the statement
%            Every customer in a restaurant saw a person who drank a
%            coffee.
% Refs     : [Bos00a] Bos (2000), DORIS: Discourse Oriented Representation a
%            [Bos00b] Bos (2000), Applied Theorem Proving - Natural Language
% Source   : [Bos00b]
% Names    : doris079 [Bos00b]
% Status   : CounterSatisfiable
% Rating   : 0.25 v3.1.0, 0.00 v2.7.0, 0.33 v2.6.0, 0.00 v2.4.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :   72 (   0 equality)
%            Maximal formula depth :   28 (  28 average)
%            Number of connectives :   73 (   2 ~  ;   0  |;  65  &)
%                                         (   0 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   13 (   0 propositional; 1-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   28 (   0 singleton;   6 !;  22 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable see_ : Universe -> Universe -> Prop.
Variable restaurant_ : Universe -> Universe -> Prop.
Variable patient_ : Universe -> Universe -> Universe -> Prop.
Variable past_ : Universe -> Universe -> Prop.
Variable nonreflexive_ : Universe -> Universe -> Prop.
Variable in_ : Universe -> Universe -> Universe -> Prop.
Variable human_person_ : Universe -> Universe -> Prop.
Variable event_ : Universe -> Universe -> Prop.
Variable drink_ : Universe -> Universe -> Prop.
Variable customer_ : Universe -> Universe -> Prop.
Variable coffee_ : Universe -> Universe -> Prop.
Variable agent_ : Universe -> Universe -> Universe -> Prop.
Variable actual_world_ : Universe -> Prop.



Theorem co1_1 : ~(~((((exists U : Universe, (actual_world_ U /\ (exists V W X Y : Universe, (coffee_ U V /\ (restaurant_ U W /\ (human_person_ U X /\ (event_ U Y /\ (agent_ U Y X /\ (patient_ U Y V /\ (past_ U Y /\ (nonreflexive_ U Y /\ (drink_ U Y /\ (forall Z : Universe, ((customer_ U Z /\ in_ U Z W) -> (exists X1 : Universe, (event_ U X1 /\ (agent_ U X1 Z /\ (patient_ U X1 X /\ (past_ U X1 /\ (nonreflexive_ U X1 /\ see_ U X1)))))))))))))))))))) -> (exists X2 : Universe, (actual_world_ X2 /\ (exists X3 : Universe, (coffee_ X2 X3 /\ (forall X4 X5 : Universe, ((customer_ X2 X4 /\ (restaurant_ X2 X5 /\ in_ X2 X4 X5)) -> (exists X6 X7 X8 : Universe, (human_person_ X2 X6 /\ (event_ X2 X7 /\ (agent_ X2 X7 X6 /\ (patient_ X2 X7 X3 /\ (past_ X2 X7 /\ (nonreflexive_ X2 X7 /\ (drink_ X2 X7 /\ (event_ X2 X8 /\ (agent_ X2 X8 X4 /\ (patient_ X2 X8 X6 /\ (past_ X2 X8 /\ (nonreflexive_ X2 X8 /\ see_ X2 X8)))))))))))))))))))) /\ ((exists X2 : Universe, (actual_world_ X2 /\ (exists X3 : Universe, (coffee_ X2 X3 /\ (forall X4 X5 : Universe, ((customer_ X2 X4 /\ (restaurant_ X2 X5 /\ in_ X2 X4 X5)) -> (exists X6 X7 X8 : Universe, (human_person_ X2 X6 /\ (event_ X2 X7 /\ (agent_ X2 X7 X6 /\ (patient_ X2 X7 X3 /\ (past_ X2 X7 /\ (nonreflexive_ X2 X7 /\ (drink_ X2 X7 /\ (event_ X2 X8 /\ (agent_ X2 X8 X4 /\ (patient_ X2 X8 X6 /\ (past_ X2 X8 /\ (nonreflexive_ X2 X8 /\ see_ X2 X8))))))))))))))))))) -> (exists U : Universe, (actual_world_ U /\ (exists V W X Y : Universe, (coffee_ U V /\ (restaurant_ U W /\ (human_person_ U X /\ (event_ U Y /\ (agent_ U Y X /\ (patient_ U Y V /\ (past_ U Y /\ (nonreflexive_ U Y /\ (drink_ U Y /\ (forall Z : Universe, ((customer_ U Z /\ in_ U Z W) -> (exists X1 : Universe, (event_ U X1 /\ (agent_ U X1 Z /\ (patient_ U X1 X /\ (past_ U X1 /\ (nonreflexive_ U X1 /\ see_ U X1)))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
