(*
% File     : NLP080+1 : ILTP v1.1.2
% Domain   : Natural Language Processing
% Problem  : A man comes out of the bathroom, problem 20
% Version  : [Bos00b] axioms.
% English  : Eliminating logically equivalent interpretations in the statement
%            A man comes out of the bathroom with a magnum in his hand.
%            The man fires six shots from his canon. He screams a cry of
%            revenge.
% Refs     : [Bos00a] Bos (2000), DORIS: Discourse Oriented Representation a
%            [Bos00b] Bos (2000), Applied Theorem Proving - Natural Language
% Source   : [Bos00b]
% Names    : doris057 [Bos00b]
% Status   : Theorem
% Rating   : 0.44 v3.1.0, 0.67 v2.7.0, 0.33 v2.6.0, 0.00 v2.4.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.25 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :  108 (   0 equality)
%            Maximal formula depth :   30 (  30 average)
%            Number of connectives :  109 (   2 ~  ;   0  |;  97  &)
%                                         (   0 <=>;  10 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   19 (   0 propositional; 1-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   40 (   0 singleton;   8 !;  32 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable six_ : Universe -> Universe -> Prop.
Variable shot_ : Universe -> Universe -> Prop.
Variable scream_ : Universe -> Universe -> Prop.
Variable revenge_ : Universe -> Universe -> Prop.
Variable present_ : Universe -> Universe -> Prop.
Variable patient_ : Universe -> Universe -> Universe -> Prop.
Variable of_ : Universe -> Universe -> Universe -> Prop.
Variable nonreflexive_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Universe -> Prop.
Variable man_ : Universe -> Universe -> Prop.
Variable male_ : Universe -> Universe -> Prop.
Variable group_ : Universe -> Universe -> Prop.
Variable from_loc_ : Universe -> Universe -> Universe -> Prop.
Variable fire_ : Universe -> Universe -> Prop.
Variable event_ : Universe -> Universe -> Prop.
Variable cry_ : Universe -> Universe -> Prop.
Variable cannon_ : Universe -> Universe -> Prop.
Variable agent_ : Universe -> Universe -> Universe -> Prop.
Variable actual_world_ : Universe -> Prop.



Theorem co1_1 : ~(~((((exists U : Universe, (actual_world_ U /\ (exists V W X Y Z X1 : Universe, (male_ U X /\ (male_ U V /\ (man_ U V /\ (of_ U W V /\ (cannon_ U W /\ ((forall X2 : Universe, (member_ U X2 X -> (exists X3 : Universe, (event_ U X3 /\ (agent_ U X3 V /\ (patient_ U X3 X2 /\ (present_ U X3 /\ (nonreflexive_ U X3 /\ (fire_ U X3 /\ from_loc_ U X3 W))))))))) /\ (six_ U X /\ (group_ U X /\ ((forall X4 : Universe, (member_ U X4 X -> shot_ U X4)) /\ (revenge_ U Y /\ (cry_ U Z /\ (event_ U X1 /\ (agent_ U X1 X /\ (patient_ U X1 Z /\ (present_ U X1 /\ (nonreflexive_ U X1 /\ (scream_ U X1 /\ of_ U X1 Y)))))))))))))))))))) -> (exists X5 : Universe, (actual_world_ X5 /\ (exists X6 X7 X8 X9 X10 X11 : Universe, (male_ X5 X8 /\ (male_ X5 X6 /\ (man_ X5 X6 /\ (of_ X5 X7 X6 /\ (cannon_ X5 X7 /\ ((forall X12 : Universe, (member_ X5 X12 X8 -> (exists X13 : Universe, (event_ X5 X13 /\ (agent_ X5 X13 X6 /\ (patient_ X5 X13 X12 /\ (present_ X5 X13 /\ (nonreflexive_ X5 X13 /\ (fire_ X5 X13 /\ from_loc_ X5 X13 X7))))))))) /\ (six_ X5 X8 /\ (group_ X5 X8 /\ ((forall X14 : Universe, (member_ X5 X14 X8 -> shot_ X5 X14)) /\ (cry_ X5 X9 /\ (revenge_ X5 X10 /\ (event_ X5 X11 /\ (agent_ X5 X11 X8 /\ (patient_ X5 X11 X9 /\ (present_ X5 X11 /\ (nonreflexive_ X5 X11 /\ (scream_ X5 X11 /\ of_ X5 X11 X10))))))))))))))))))))) /\ ((exists X5 : Universe, (actual_world_ X5 /\ (exists X6 X7 X8 X9 X10 X11 : Universe, (male_ X5 X8 /\ (male_ X5 X6 /\ (man_ X5 X6 /\ (of_ X5 X7 X6 /\ (cannon_ X5 X7 /\ ((forall X12 : Universe, (member_ X5 X12 X8 -> (exists X13 : Universe, (event_ X5 X13 /\ (agent_ X5 X13 X6 /\ (patient_ X5 X13 X12 /\ (present_ X5 X13 /\ (nonreflexive_ X5 X13 /\ (fire_ X5 X13 /\ from_loc_ X5 X13 X7))))))))) /\ (six_ X5 X8 /\ (group_ X5 X8 /\ ((forall X14 : Universe, (member_ X5 X14 X8 -> shot_ X5 X14)) /\ (cry_ X5 X9 /\ (revenge_ X5 X10 /\ (event_ X5 X11 /\ (agent_ X5 X11 X8 /\ (patient_ X5 X11 X9 /\ (present_ X5 X11 /\ (nonreflexive_ X5 X11 /\ (scream_ X5 X11 /\ of_ X5 X11 X10)))))))))))))))))))) -> (exists U : Universe, (actual_world_ U /\ (exists V W X Y Z X1 : Universe, (male_ U X /\ (male_ U V /\ (man_ U V /\ (of_ U W V /\ (cannon_ U W /\ ((forall X2 : Universe, (member_ U X2 X -> (exists X3 : Universe, (event_ U X3 /\ (agent_ U X3 V /\ (patient_ U X3 X2 /\ (present_ U X3 /\ (nonreflexive_ U X3 /\ (fire_ U X3 /\ from_loc_ U X3 W))))))))) /\ (six_ U X /\ (group_ U X /\ ((forall X4 : Universe, (member_ U X4 X -> shot_ U X4)) /\ (revenge_ U Y /\ (cry_ U Z /\ (event_ U X1 /\ (agent_ U X1 X /\ (patient_ U X1 Z /\ (present_ U X1 /\ (nonreflexive_ U X1 /\ (scream_ U X1 /\ of_ U X1 Y)))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
