(*
% File     : NLP079+1 : ILTP v1.1.2
% Domain   : Natural Language Processing
% Problem  : A man comes out of the bathroom, problem 19
% Version  : [Bos00b] axioms.
% English  : Eliminating logically equivalent interpretations in the statement
%            A man comes out of the bathroom with a magnum in his hand.
%            The man fires six shots from his canon. He screams a cry of
%            revenge.
% Refs     : [Bos00a] Bos (2000), DORIS: Discourse Oriented Representation a
%            [Bos00b] Bos (2000), Applied Theorem Proving - Natural Language
% Source   : [Bos00b]
% Names    : doris056 [Bos00b]
% Status   : Theorem
% Rating   : 0.44 v3.1.0, 0.67 v2.7.0, 0.33 v2.6.0, 0.00 v2.4.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.25 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :  108 (   0 equality)
%            Maximal formula depth :   31 (  31 average)
%            Number of connectives :  109 (   2 ~  ;   0  |;  97  &)
%                                         (   0 <=>;  10 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   19 (   0 propositional; 1-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   44 (   0 singleton;   8 !;  36 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable six_ : Universe -> Universe -> Prop.
Variable shot_ : Universe -> Universe -> Prop.
Variable scream_ : Universe -> Universe -> Prop.
Variable revenge_ : Universe -> Universe -> Prop.
Variable present_ : Universe -> Universe -> Prop.
Variable patient_ : Universe -> Universe -> Universe -> Prop.
Variable of_ : Universe -> Universe -> Universe -> Prop.
Variable nonreflexive_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Universe -> Prop.
Variable man_ : Universe -> Universe -> Prop.
Variable male_ : Universe -> Universe -> Prop.
Variable group_ : Universe -> Universe -> Prop.
Variable from_loc_ : Universe -> Universe -> Universe -> Prop.
Variable fire_ : Universe -> Universe -> Prop.
Variable event_ : Universe -> Universe -> Prop.
Variable cry_ : Universe -> Universe -> Prop.
Variable cannon_ : Universe -> Universe -> Prop.
Variable agent_ : Universe -> Universe -> Universe -> Prop.
Variable actual_world_ : Universe -> Prop.



Theorem co1_1 : ~(~((((exists U : Universe, (actual_world_ U /\ (exists V W X Y Z X1 X2 : Universe, (male_ U V /\ (male_ U W /\ (man_ U W /\ (of_ U X W /\ (cannon_ U X /\ ((forall X3 : Universe, (member_ U X3 Y -> (exists X4 : Universe, (event_ U X4 /\ (agent_ U X4 W /\ (patient_ U X4 X3 /\ (present_ U X4 /\ (nonreflexive_ U X4 /\ (fire_ U X4 /\ from_loc_ U X4 X))))))))) /\ (six_ U Y /\ (group_ U Y /\ ((forall X5 : Universe, (member_ U X5 Y -> shot_ U X5)) /\ (revenge_ U Z /\ (cry_ U X1 /\ (event_ U X2 /\ (agent_ U X2 V /\ (patient_ U X2 X1 /\ (present_ U X2 /\ (nonreflexive_ U X2 /\ (scream_ U X2 /\ of_ U X2 Z)))))))))))))))))))) -> (exists X6 : Universe, (actual_world_ X6 /\ (exists X7 X8 X9 X10 X11 X12 X13 : Universe, (male_ X6 X7 /\ (male_ X6 X8 /\ (man_ X6 X8 /\ (of_ X6 X9 X8 /\ (cannon_ X6 X9 /\ ((forall X14 : Universe, (member_ X6 X14 X10 -> (exists X15 : Universe, (event_ X6 X15 /\ (agent_ X6 X15 X8 /\ (patient_ X6 X15 X14 /\ (present_ X6 X15 /\ (nonreflexive_ X6 X15 /\ (fire_ X6 X15 /\ from_loc_ X6 X15 X9))))))))) /\ (six_ X6 X10 /\ (group_ X6 X10 /\ ((forall X16 : Universe, (member_ X6 X16 X10 -> shot_ X6 X16)) /\ (cry_ X6 X11 /\ (revenge_ X6 X12 /\ (event_ X6 X13 /\ (agent_ X6 X13 X7 /\ (patient_ X6 X13 X11 /\ (present_ X6 X13 /\ (nonreflexive_ X6 X13 /\ (scream_ X6 X13 /\ of_ X6 X13 X12))))))))))))))))))))) /\ ((exists X6 : Universe, (actual_world_ X6 /\ (exists X7 X8 X9 X10 X11 X12 X13 : Universe, (male_ X6 X7 /\ (male_ X6 X8 /\ (man_ X6 X8 /\ (of_ X6 X9 X8 /\ (cannon_ X6 X9 /\ ((forall X14 : Universe, (member_ X6 X14 X10 -> (exists X15 : Universe, (event_ X6 X15 /\ (agent_ X6 X15 X8 /\ (patient_ X6 X15 X14 /\ (present_ X6 X15 /\ (nonreflexive_ X6 X15 /\ (fire_ X6 X15 /\ from_loc_ X6 X15 X9))))))))) /\ (six_ X6 X10 /\ (group_ X6 X10 /\ ((forall X16 : Universe, (member_ X6 X16 X10 -> shot_ X6 X16)) /\ (cry_ X6 X11 /\ (revenge_ X6 X12 /\ (event_ X6 X13 /\ (agent_ X6 X13 X7 /\ (patient_ X6 X13 X11 /\ (present_ X6 X13 /\ (nonreflexive_ X6 X13 /\ (scream_ X6 X13 /\ of_ X6 X13 X12)))))))))))))))))))) -> (exists U : Universe, (actual_world_ U /\ (exists V W X Y Z X1 X2 : Universe, (male_ U V /\ (male_ U W /\ (man_ U W /\ (of_ U X W /\ (cannon_ U X /\ ((forall X3 : Universe, (member_ U X3 Y -> (exists X4 : Universe, (event_ U X4 /\ (agent_ U X4 W /\ (patient_ U X4 X3 /\ (present_ U X4 /\ (nonreflexive_ U X4 /\ (fire_ U X4 /\ from_loc_ U X4 X))))))))) /\ (six_ U Y /\ (group_ U Y /\ ((forall X5 : Universe, (member_ U X5 Y -> shot_ U X5)) /\ (revenge_ U Z /\ (cry_ U X1 /\ (event_ U X2 /\ (agent_ U X2 V /\ (patient_ U X2 X1 /\ (present_ U X2 /\ (nonreflexive_ U X2 /\ (scream_ U X2 /\ of_ U X2 Z)))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
