(*
% File     : NLP073+1 : ILTP v1.1.2
% Domain   : Natural Language Processing
% Problem  : A man comes out of the bathroom, problem 14
% Version  : [Bos00b] axioms.
% English  : Eliminating inconsistent interpretations in the statement
%            A man comes out of the bathroom with a magnum in his hand.
%            The man fires six shots from his canon.
% Refs     : [Bos00a] Bos (2000), DORIS: Discourse Oriented Representation a
%            [Bos00b] Bos (2000), Applied Theorem Proving - Natural Language
% Source   : [Bos00b]
% Names    : doris050 [Bos00b]
% Status   : CounterSatisfiable
% Rating   : 0.25 v3.1.0, 0.50 v2.6.0, 0.25 v2.5.0, 0.33 v2.4.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   42 (   1 unit)
%            Number of atoms       :  127 (  22 equality)
%            Maximal formula depth :   38 (   5 average)
%            Number of connectives :  108 (  23 ~  ;   5  |;  37  &)
%                                         (   1 <=>;  42 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   41 (   0 propositional; 1-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   99 (   0 singleton;  87 !;  12 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable weaponry_ : Universe -> Universe -> Prop.
Variable weapon_ : Universe -> Universe -> Prop.
Variable unisex_ : Universe -> Universe -> Prop.
Variable thing_ : Universe -> Universe -> Prop.
Variable specific_ : Universe -> Universe -> Prop.
Variable six_ : Universe -> Universe -> Prop.
Variable singleton_ : Universe -> Universe -> Prop.
Variable shot_ : Universe -> Universe -> Prop.
Variable set_ : Universe -> Universe -> Prop.
Variable present_ : Universe -> Universe -> Prop.
Variable patient_ : Universe -> Universe -> Universe -> Prop.
Variable organism_ : Universe -> Universe -> Prop.
Variable of_ : Universe -> Universe -> Universe -> Prop.
Variable object_ : Universe -> Universe -> Prop.
Variable nonreflexive_ : Universe -> Universe -> Prop.
Variable nonliving_ : Universe -> Universe -> Prop.
Variable nonexistent_ : Universe -> Universe -> Prop.
Variable multiple_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Universe -> Prop.
Variable man_ : Universe -> Universe -> Prop.
Variable male_ : Universe -> Universe -> Prop.
Variable living_ : Universe -> Universe -> Prop.
Variable instrumentality_ : Universe -> Universe -> Prop.
Variable impartial_ : Universe -> Universe -> Prop.
Variable human_person_ : Universe -> Universe -> Prop.
Variable human_ : Universe -> Universe -> Prop.
Variable group_ : Universe -> Universe -> Prop.
Variable from_loc_ : Universe -> Universe -> Universe -> Prop.
Variable fire_ : Universe -> Universe -> Prop.
Variable existent_ : Universe -> Universe -> Prop.
Variable eventuality_ : Universe -> Universe -> Prop.
Variable event_ : Universe -> Universe -> Prop.
Variable entity_ : Universe -> Universe -> Prop.
Variable cannon_ : Universe -> Universe -> Prop.
Variable artifact_ : Universe -> Universe -> Prop.
Variable animate_ : Universe -> Universe -> Prop.
Variable agent_ : Universe -> Universe -> Universe -> Prop.
Variable actual_world_ : Universe -> Prop.
Variable action_ : Universe -> Universe -> Prop.
Variable act_ : Universe -> Universe -> Prop.


Variable ax1_1 : (forall U V : Universe, (man_ U V -> male_ U V)).
Variable ax2_2 : (forall U V : Universe, (human_person_ U V -> animate_ U V)).
Variable ax3_3 : (forall U V : Universe, (human_person_ U V -> human_ U V)).
Variable ax4_4 : (forall U V : Universe, (organism_ U V -> living_ U V)).
Variable ax5_5 : (forall U V : Universe, (organism_ U V -> impartial_ U V)).
Variable ax6_6 : (forall U V : Universe, (organism_ U V -> entity_ U V)).
Variable ax7_7 : (forall U V : Universe, (human_person_ U V -> organism_ U V)).
Variable ax8_8 : (forall U V : Universe, (man_ U V -> human_person_ U V)).
Variable ax9_9 : (forall U V : Universe, (object_ U V -> unisex_ U V)).
Variable ax10_10 : (forall U V : Universe, (object_ U V -> impartial_ U V)).
Variable ax11_11 : (forall U V : Universe, (object_ U V -> nonliving_ U V)).
Variable ax12_12 : (forall U V : Universe, (entity_ U V -> existent_ U V)).
Variable ax13_13 : (forall U V : Universe, (entity_ U V -> specific_ U V)).
Variable ax14_14 : (forall U V : Universe, (entity_ U V -> thing_ U V)).
Variable ax15_15 : (forall U V : Universe, (object_ U V -> entity_ U V)).
Variable ax16_16 : (forall U V : Universe, (artifact_ U V -> object_ U V)).
Variable ax17_17 : (forall U V : Universe, (instrumentality_ U V -> artifact_ U V)).
Variable ax18_18 : (forall U V : Universe, (weaponry_ U V -> instrumentality_ U V)).
Variable ax19_19 : (forall U V : Universe, (weapon_ U V -> weaponry_ U V)).
Variable ax20_20 : (forall U V : Universe, (cannon_ U V -> weapon_ U V)).
Variable ax21_21 : (forall U V : Universe, (fire_ U V -> event_ U V)).
Variable ax22_22 : (forall U V : Universe, (six_ U V -> group_ U V)).
Variable ax23_23 : (forall U V : Universe, (set_ U V -> multiple_ U V)).
Variable ax24_24 : (forall U V : Universe, (group_ U V -> set_ U V)).
Variable ax25_25 : (forall U V : Universe, (eventuality_ U V -> unisex_ U V)).
Variable ax26_26 : (forall U V : Universe, (eventuality_ U V -> nonexistent_ U V)).
Variable ax27_27 : (forall U V : Universe, (eventuality_ U V -> specific_ U V)).
Variable ax28_28 : (forall U V : Universe, (thing_ U V -> singleton_ U V)).
Variable ax29_29 : (forall U V : Universe, (eventuality_ U V -> thing_ U V)).
Variable ax30_30 : (forall U V : Universe, (event_ U V -> eventuality_ U V)).
Variable ax31_31 : (forall U V : Universe, (act_ U V -> event_ U V)).
Variable ax32_32 : (forall U V : Universe, (action_ U V -> act_ U V)).
Variable ax33_33 : (forall U V : Universe, (shot_ U V -> action_ U V)).
Variable ax34_34 : (forall U V : Universe, (animate_ U V -> ~(nonliving_ U V))).
Variable ax35_35 : (forall U V : Universe, (existent_ U V -> ~(nonexistent_ U V))).
Variable ax36_36 : (forall U V : Universe, (nonliving_ U V -> ~(living_ U V))).
Variable ax37_37 : (forall U V : Universe, (singleton_ U V -> ~(multiple_ U V))).
Variable ax38_38 : (forall U V : Universe, (unisex_ U V -> ~(male_ U V))).
Variable ax39_39 : (forall U V W X : Universe, ((nonreflexive_ U V /\ (agent_ U V W /\ patient_ U V X)) -> W <> X)).
Variable ax40_40 : (forall U V : Universe, (six_ U V <-> (exists W : Universe, (member_ U W V /\ (exists X : Universe, (member_ U X V /\ (X <> W /\ (exists Y : Universe, (member_ U Y V /\ (Y <> X /\ (Y <> W /\ (exists Z : Universe, (member_ U Z V /\ (Z <> Y /\ (Z <> X /\ (Z <> W /\ (exists X1 : Universe, (member_ U X1 V /\ (X1 <> Z /\ (X1 <> Y /\ (X1 <> X /\ (X1 <> W /\ (exists X2 : Universe, (member_ U X2 V /\ (X2 <> X1 /\ (X2 <> Z /\ (X2 <> Y /\ (X2 <> X /\ (X2 <> W /\ (forall X3 : Universe, (member_ U X3 V -> (X3 = X2 \/ (X3 = X1 \/ (X3 = Z \/ (X3 = Y \/ (X3 = X \/ X3 = W)))))))))))))))))))))))))))))))))))).
Variable ax41_41 : (forall U : Universe, ~((exists V : Universe, member_ U V V))).

Theorem co1_42 : ~((exists U : Universe, (actual_world_ U /\ (exists V W : Universe, (male_ U V /\ ((forall X Y : Universe, ((man_ U X /\ member_ U Y W) -> (exists Z X1 : Universe, (of_ U Z V /\ (cannon_ U Z /\ (event_ U X1 /\ (agent_ U X1 X /\ (patient_ U X1 Y /\ (present_ U X1 /\ (nonreflexive_ U X1 /\ (fire_ U X1 /\ from_loc_ U X1 Z))))))))))) /\ (six_ U W /\ (group_ U W /\ (forall X2 : Universe, (member_ U X2 W -> shot_ U X2)))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
