(*
% File     : NLP062+1 : ILTP v1.1.2
% Domain   : Natural Language Processing
% Problem  : A man comes out of the bathroom, problem 4
% Version  : [Bos00b] axioms.
% English  : Eliminating logically equivalent interpretations in the statement
%            A man comes out of the bathroom with a magnum in his hand.
%            The man fires six shots from his canon.
% Refs     : [Bos00a] Bos (2000), DORIS: Discourse Oriented Representation a
%            [Bos00b] Bos (2000), Applied Theorem Proving - Natural Language
% Source   : [Bos00b]
% Names    : doris039 [Bos00b]
% Status   : CounterSatisfiable
% Rating   : 0.25 v3.1.0, 0.17 v2.7.0, 0.50 v2.6.0, 0.25 v2.5.0, 0.33 v2.4.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :   68 (   0 equality)
%            Maximal formula depth :   24 (  24 average)
%            Number of connectives :   69 (   2 ~  ;   0  |;  57  &)
%                                         (   0 <=>;  10 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   16 (   0 propositional; 1-3 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   32 (   0 singleton;  12 !;  20 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable six_ : Universe -> Universe -> Prop.
Variable shot_ : Universe -> Universe -> Prop.
Variable present_ : Universe -> Universe -> Prop.
Variable patient_ : Universe -> Universe -> Universe -> Prop.
Variable of_ : Universe -> Universe -> Universe -> Prop.
Variable nonreflexive_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Universe -> Prop.
Variable man_ : Universe -> Universe -> Prop.
Variable male_ : Universe -> Universe -> Prop.
Variable group_ : Universe -> Universe -> Prop.
Variable from_loc_ : Universe -> Universe -> Universe -> Prop.
Variable fire_ : Universe -> Universe -> Prop.
Variable event_ : Universe -> Universe -> Prop.
Variable cannon_ : Universe -> Universe -> Prop.
Variable agent_ : Universe -> Universe -> Universe -> Prop.
Variable actual_world_ : Universe -> Prop.



Theorem co1_1 : ~(~((((exists U : Universe, (actual_world_ U /\ (exists V W : Universe, (male_ U V /\ ((forall X Y : Universe, ((of_ U X V /\ (cannon_ U X /\ member_ U Y W)) -> (exists Z X1 : Universe, (man_ U Z /\ (event_ U X1 /\ (agent_ U X1 Z /\ (patient_ U X1 Y /\ (present_ U X1 /\ (nonreflexive_ U X1 /\ (fire_ U X1 /\ from_loc_ U X1 X)))))))))) /\ (six_ U W /\ (group_ U W /\ (forall X2 : Universe, (member_ U X2 W -> shot_ U X2))))))))) -> (exists X3 : Universe, (actual_world_ X3 /\ (exists X4 X5 : Universe, (male_ X3 X4 /\ ((forall X6 X7 : Universe, ((man_ X3 X6 /\ member_ X3 X7 X5) -> (exists X8 X9 : Universe, (of_ X3 X8 X4 /\ (cannon_ X3 X8 /\ (event_ X3 X9 /\ (agent_ X3 X9 X6 /\ (patient_ X3 X9 X7 /\ (present_ X3 X9 /\ (nonreflexive_ X3 X9 /\ (fire_ X3 X9 /\ from_loc_ X3 X9 X8))))))))))) /\ (six_ X3 X5 /\ (group_ X3 X5 /\ (forall X10 : Universe, (member_ X3 X10 X5 -> shot_ X3 X10)))))))))) /\ ((exists X3 : Universe, (actual_world_ X3 /\ (exists X4 X5 : Universe, (male_ X3 X4 /\ ((forall X6 X7 : Universe, ((man_ X3 X6 /\ member_ X3 X7 X5) -> (exists X8 X9 : Universe, (of_ X3 X8 X4 /\ (cannon_ X3 X8 /\ (event_ X3 X9 /\ (agent_ X3 X9 X6 /\ (patient_ X3 X9 X7 /\ (present_ X3 X9 /\ (nonreflexive_ X3 X9 /\ (fire_ X3 X9 /\ from_loc_ X3 X9 X8))))))))))) /\ (six_ X3 X5 /\ (group_ X3 X5 /\ (forall X10 : Universe, (member_ X3 X10 X5 -> shot_ X3 X10))))))))) -> (exists U : Universe, (actual_world_ U /\ (exists V W : Universe, (male_ U V /\ ((forall X Y : Universe, ((of_ U X V /\ (cannon_ U X /\ member_ U Y W)) -> (exists Z X1 : Universe, (man_ U Z /\ (event_ U X1 /\ (agent_ U X1 Z /\ (patient_ U X1 Y /\ (present_ U X1 /\ (nonreflexive_ U X1 /\ (fire_ U X1 /\ from_loc_ U X1 X)))))))))) /\ (six_ U W /\ (group_ U W /\ (forall X2 : Universe, (member_ U X2 W -> shot_ U X2))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
