(*
% File     : MGT065+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Long-run hazard of mortality
% Version  : [Han98] axioms.
% English  : The long-run hazard of mortality for an endowed organization with
%            either a fragile or a robust position in a drifting environment
%            exceeds the hazard near founding.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : THEOREM 11 [Han98]
% Status   : Theorem
% Rating   : 0.36 v3.1.0, 0.44 v2.7.0, 0.33 v2.6.0, 0.50 v2.5.0, 0.33 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   17 (   5 unit)
%            Number of atoms       :   70 (  12 equality)
%            Maximal formula depth :   18 (   5 average)
%            Number of connectives :   61 (   8 ~  ;   5  |;  28  &)
%                                         (   7 <=>;  13 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   13 (   0 propositional; 1-3 arity)
%            Number of functors    :   11 (   9 constant; 0-2 arity)
%            Number of variables   :   29 (   0 singleton;  29 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable smaller_ : Universe -> Universe -> Prop.
Variable robust_position_ : Universe -> Prop.
Variable positional_advantage_ : Universe -> Universe -> Prop.
Variable organization_ : Universe -> Prop.
Variable is_aligned_ : Universe -> Universe -> Prop.
Variable has_immunity_ : Universe -> Universe -> Prop.
Variable has_endowment_ : Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable fragile_position_ : Universe -> Prop.
Variable dissimilar_ : Universe -> Universe -> Universe -> Prop.

Variable zero_ : Universe.
Variable very_low_ : Universe.
Variable tau_ : Universe.
Variable sigma_ : Universe.
Variable mod2_ : Universe.
Variable mod1_ : Universe.
Variable low_ : Universe.
Variable high_ : Universe.
Variable hazard_of_mortality_ : Universe -> Universe -> Universe.
Variable eta_ : Universe.
Variable age_ : Universe -> Universe -> Universe.

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable definition_1_7 : (forall X : Universe, (has_endowment_ X <-> (forall T : Universe, (organization_ X /\ ((smaller_or_equal_ (age_ X T) eta_ -> has_immunity_ X T) /\ (greater_ (age_ X T) eta_ -> ~(has_immunity_ X T))))))).
Variable definition_2_8 : (forall X T0 T : Universe, (dissimilar_ X T0 T <-> (organization_ X /\ ~((is_aligned_ X T0 <-> is_aligned_ X T))))).
Variable assumption_13_9 : (forall X T : Universe, ((organization_ X /\ (age_ X T) = zero_) -> is_aligned_ X T)).
Variable assumption_15_10 : (forall X T0 T : Universe, ((organization_ X /\ (age_ X T0) = zero_) -> (greater_ (age_ X T) sigma_ <-> dissimilar_ X T0 T))).
Variable assumption_17_11 : (forall X T : Universe, (organization_ X -> ((has_immunity_ X T -> (hazard_of_mortality_ X T) = very_low_) /\ (~(has_immunity_ X T) -> (((is_aligned_ X T /\ positional_advantage_ X T) -> (hazard_of_mortality_ X T) = low_) /\ (((~(is_aligned_ X T) /\ positional_advantage_ X T) -> (hazard_of_mortality_ X T) = mod1_) /\ (((is_aligned_ X T /\ ~(positional_advantage_ X T)) -> (hazard_of_mortality_ X T) = mod2_) /\ ((~(is_aligned_ X T) /\ ~(positional_advantage_ X T)) -> (hazard_of_mortality_ X T) = high_)))))))).
Variable assumption_18a_12 : greater_ high_ mod1_.
Variable assumption_18b_13 : greater_ mod1_ low_.
Variable assumption_18c_14 : greater_ low_ very_low_.
Variable assumption_18d_15 : greater_ high_ mod2_.
Variable assumption_18e_16 : greater_ mod2_ low_.

Theorem theorem_11_17 : (forall X T0 T1 T2 : Universe, ((organization_ X /\ ((robust_position_ X \/ fragile_position_ X) /\ (has_endowment_ X /\ ((age_ X T0) = zero_ /\ (greater_ sigma_ zero_ /\ (greater_ tau_ zero_ /\ (greater_ eta_ zero_ /\ (smaller_or_equal_ (age_ X T1) sigma_ /\ (smaller_or_equal_ (age_ X T1) tau_ /\ (smaller_or_equal_ (age_ X T1) eta_ /\ (greater_ (age_ X T2) sigma_ /\ (greater_ (age_ X T2) tau_ /\ greater_ (age_ X T2) eta_)))))))))))) -> (greater_ (hazard_of_mortality_ X T2) (hazard_of_mortality_ X T1) /\ (hazard_of_mortality_ X T1) = (hazard_of_mortality_ X T0)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
