(*
% File     : MGT064+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Conditions for a decreasing then increasing hazard of mortality
% Version  : [Han98] axioms.
% English  : If advantage can be gained from occupancy of a robust position
%            before environmental drift destroys alignment, then the hazard 
%            of mortality for an unendowed organization with a robust 
%            position initially decreases with age and then rises with
%            further aging but remains below the initial level.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : THEOREM 10 [Han98]
% Status   : Theorem
% Rating   : 0.55 v3.1.0, 0.67 v2.6.0, 0.83 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   20 (   6 unit)
%            Number of atoms       :   77 (  12 equality)
%            Maximal formula depth :   17 (   5 average)
%            Number of connectives :   69 (  12 ~  ;   4  |;  29  &)
%                                         (   8 <=>;  16 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   12 (   0 propositional; 1-3 arity)
%            Number of functors    :   11 (   9 constant; 0-2 arity)
%            Number of variables   :   34 (   0 singleton;  34 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable smaller_ : Universe -> Universe -> Prop.
Variable robust_position_ : Universe -> Prop.
Variable positional_advantage_ : Universe -> Universe -> Prop.
Variable organization_ : Universe -> Prop.
Variable is_aligned_ : Universe -> Universe -> Prop.
Variable has_immunity_ : Universe -> Universe -> Prop.
Variable has_endowment_ : Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable dissimilar_ : Universe -> Universe -> Universe -> Prop.

Variable zero_ : Universe.
Variable very_low_ : Universe.
Variable tau_ : Universe.
Variable sigma_ : Universe.
Variable mod2_ : Universe.
Variable mod1_ : Universe.
Variable low_ : Universe.
Variable high_ : Universe.
Variable hazard_of_mortality_ : Universe -> Universe -> Universe.
Variable eta_ : Universe.
Variable age_ : Universe -> Universe -> Universe.

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable definition_1_7 : (forall X : Universe, (has_endowment_ X <-> (forall T : Universe, (organization_ X /\ ((smaller_or_equal_ (age_ X T) eta_ -> has_immunity_ X T) /\ (greater_ (age_ X T) eta_ -> ~(has_immunity_ X T))))))).
Variable assumption_1_8 : (forall X T : Universe, ((organization_ X /\ ~(has_endowment_ X)) -> ~(has_immunity_ X T))).
Variable definition_2_9 : (forall X T0 T : Universe, (dissimilar_ X T0 T <-> (organization_ X /\ ~((is_aligned_ X T0 <-> is_aligned_ X T))))).
Variable assumption_13_10 : (forall X T : Universe, ((organization_ X /\ (age_ X T) = zero_) -> is_aligned_ X T)).
Variable assumption_15_11 : (forall X T0 T : Universe, ((organization_ X /\ (age_ X T0) = zero_) -> (greater_ (age_ X T) sigma_ <-> dissimilar_ X T0 T))).
Variable definition_4_12 : (forall X : Universe, (robust_position_ X <-> (forall T : Universe, ((smaller_or_equal_ (age_ X T) tau_ -> ~(positional_advantage_ X T)) /\ (greater_ (age_ X T) tau_ -> positional_advantage_ X T))))).
Variable assumption_17_13 : (forall X T : Universe, (organization_ X -> ((has_immunity_ X T -> (hazard_of_mortality_ X T) = very_low_) /\ (~(has_immunity_ X T) -> (((is_aligned_ X T /\ positional_advantage_ X T) -> (hazard_of_mortality_ X T) = low_) /\ (((~(is_aligned_ X T) /\ positional_advantage_ X T) -> (hazard_of_mortality_ X T) = mod1_) /\ (((is_aligned_ X T /\ ~(positional_advantage_ X T)) -> (hazard_of_mortality_ X T) = mod2_) /\ ((~(is_aligned_ X T) /\ ~(positional_advantage_ X T)) -> (hazard_of_mortality_ X T) = high_)))))))).
Variable assumption_18a_14 : greater_ high_ mod1_.
Variable assumption_18b_15 : greater_ mod1_ low_.
Variable assumption_18c_16 : greater_ low_ very_low_.
Variable assumption_18d_17 : greater_ high_ mod2_.
Variable assumption_18e_18 : greater_ mod2_ low_.
Variable assumption_19_19 : greater_ mod2_ mod1_.

Theorem theorem_10_20 : (forall X T0 T1 T2 T3 : Universe, ((organization_ X /\ (robust_position_ X /\ (~(has_endowment_ X) /\ ((age_ X T0) = zero_ /\ (greater_ sigma_ zero_ /\ (greater_ tau_ zero_ /\ (greater_ sigma_ tau_ /\ (smaller_or_equal_ (age_ X T1) tau_ /\ (greater_ (age_ X T2) tau_ /\ (smaller_or_equal_ (age_ X T2) sigma_ /\ greater_ (age_ X T3) sigma_)))))))))) -> (smaller_ (hazard_of_mortality_ X T2) (hazard_of_mortality_ X T3) /\ (smaller_ (hazard_of_mortality_ X T3) (hazard_of_mortality_ X T1) /\ (hazard_of_mortality_ X T1) = (hazard_of_mortality_ X T0))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
