(*
% File     : MGT062+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Condictions for decreasing hazard of mortality
% Version  : [Han98] axioms.
% English  : If environmental drift destroys alignment exactly when advantage 
%            can be gained from occupancy of a robust position, then the 
%            hazard of mortality for an unendowed organization with a robust 
%            position decreases with age.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : THEOREM 8 [Han98]
% Status   : Theorem
% Rating   : 0.36 v3.1.0, 0.56 v2.7.0, 0.33 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   14 (   1 unit)
%            Number of atoms       :   63 (  13 equality)
%            Maximal formula depth :   14 (   6 average)
%            Number of connectives :   60 (  11 ~  ;   4  |;  24  &)
%                                         (   7 <=>;  14 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   12 (   0 propositional; 1-3 arity)
%            Number of functors    :   10 (   8 constant; 0-2 arity)
%            Number of variables   :   31 (   0 singleton;  31 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable smaller_ : Universe -> Universe -> Prop.
Variable robust_position_ : Universe -> Prop.
Variable positional_advantage_ : Universe -> Universe -> Prop.
Variable organization_ : Universe -> Prop.
Variable is_aligned_ : Universe -> Universe -> Prop.
Variable has_immunity_ : Universe -> Universe -> Prop.
Variable has_endowment_ : Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable dissimilar_ : Universe -> Universe -> Universe -> Prop.

Variable zero_ : Universe.
Variable very_low_ : Universe.
Variable tau_ : Universe.
Variable sigma_ : Universe.
Variable mod2_ : Universe.
Variable mod1_ : Universe.
Variable low_ : Universe.
Variable high_ : Universe.
Variable hazard_of_mortality_ : Universe -> Universe -> Universe.
Variable age_ : Universe -> Universe -> Universe.

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable assumption_1_7 : (forall X T : Universe, ((organization_ X /\ ~(has_endowment_ X)) -> ~(has_immunity_ X T))).
Variable definition_2_8 : (forall X T0 T : Universe, (dissimilar_ X T0 T <-> (organization_ X /\ ~((is_aligned_ X T0 <-> is_aligned_ X T))))).
Variable assumption_13_9 : (forall X T : Universe, ((organization_ X /\ (age_ X T) = zero_) -> is_aligned_ X T)).
Variable assumption_15_10 : (forall X T0 T : Universe, ((organization_ X /\ (age_ X T0) = zero_) -> (greater_ (age_ X T) sigma_ <-> dissimilar_ X T0 T))).
Variable definition_4_11 : (forall X : Universe, (robust_position_ X <-> (forall T : Universe, ((smaller_or_equal_ (age_ X T) tau_ -> ~(positional_advantage_ X T)) /\ (greater_ (age_ X T) tau_ -> positional_advantage_ X T))))).
Variable assumption_17_12 : (forall X T : Universe, (organization_ X -> ((has_immunity_ X T -> (hazard_of_mortality_ X T) = very_low_) /\ (~(has_immunity_ X T) -> (((is_aligned_ X T /\ positional_advantage_ X T) -> (hazard_of_mortality_ X T) = low_) /\ (((~(is_aligned_ X T) /\ positional_advantage_ X T) -> (hazard_of_mortality_ X T) = mod1_) /\ (((is_aligned_ X T /\ ~(positional_advantage_ X T)) -> (hazard_of_mortality_ X T) = mod2_) /\ ((~(is_aligned_ X T) /\ ~(positional_advantage_ X T)) -> (hazard_of_mortality_ X T) = high_)))))))).
Variable assumption_19_13 : greater_ mod2_ mod1_.

Theorem theorem_8_14 : (forall X T0 T1 T2 : Universe, ((organization_ X /\ (robust_position_ X /\ (~(has_endowment_ X) /\ ((age_ X T0) = zero_ /\ (greater_ sigma_ zero_ /\ (greater_ tau_ zero_ /\ (sigma_ = tau_ /\ (smaller_or_equal_ (age_ X T1) sigma_ /\ greater_ (age_ X T2) sigma_)))))))) -> (smaller_ (hazard_of_mortality_ X T2) (hazard_of_mortality_ X T1) /\ (hazard_of_mortality_ X T1) = (hazard_of_mortality_ X T0)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
