(*
% File     : MGT058+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : An organization's position cannot be both fragile and robust
% Version  : [Han98] axioms.
% English  : 
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : LEMMA 10 [Han98]
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.22 v2.7.0, 0.33 v2.5.0, 0.17 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    9 (   0 unit)
%            Number of atoms       :   32 (   4 equality)
%            Maximal formula depth :    7 (   6 average)
%            Number of connectives :   27 (   4 ~  ;   4  |;   8  &)
%                                         (   5 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 1-2 arity)
%            Number of functors    :    4 (   3 constant; 0-2 arity)
%            Number of variables   :   19 (   0 singleton;  18 !;   1 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable smaller_ : Universe -> Universe -> Prop.
Variable robust_position_ : Universe -> Prop.
Variable positional_advantage_ : Universe -> Universe -> Prop.
Variable organization_ : Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable fragile_position_ : Universe -> Prop.

Variable zero_ : Universe.
Variable tau_ : Universe.
Variable sigma_ : Universe.
Variable age_ : Universe -> Universe -> Universe.

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable definition_3_7 : (forall X : Universe, (fragile_position_ X <-> (forall T : Universe, ((smaller_or_equal_ (age_ X T) sigma_ -> positional_advantage_ X T) /\ (greater_ (age_ X T) sigma_ -> ~(positional_advantage_ X T)))))).
Variable definition_4_8 : (forall X : Universe, (robust_position_ X <-> (forall T : Universe, ((smaller_or_equal_ (age_ X T) tau_ -> ~(positional_advantage_ X T)) /\ (greater_ (age_ X T) tau_ -> positional_advantage_ X T))))).

Theorem lemma_10_9 : (forall X : Universe, ((organization_ X /\ ((exists T0 : Universe, (age_ X T0) = zero_) /\ (greater_or_equal_ sigma_ zero_ /\ greater_or_equal_ tau_ zero_))) -> ~((fragile_position_ X /\ robust_position_ X)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
