(*
% File     : MGT056+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Conditions for a constant then jumping hazard of mortality 2
% Version  : [Han98] axioms.
% English  : When (`eta' >= `sigma') in a drifting environment, an endowed
%            organization's hazard of mortality remains constant until age
%            `eta' and then jumps to a higher level in a drifting environment.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : LEMMA 9 [Han98]
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.11 v2.7.0, 0.17 v2.6.0, 0.33 v2.5.0, 0.17 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   10 (   0 unit)
%            Number of atoms       :   39 (   6 equality)
%            Maximal formula depth :   12 (   6 average)
%            Number of connectives :   32 (   3 ~  ;   4  |;  15  &)
%                                         (   4 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-2 arity)
%            Number of functors    :    5 (   3 constant; 0-2 arity)
%            Number of variables   :   25 (   0 singleton;  25 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable smaller_ : Universe -> Universe -> Prop.
Variable organization_ : Universe -> Prop.
Variable has_immunity_ : Universe -> Universe -> Prop.
Variable has_endowment_ : Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.

Variable zero_ : Universe.
Variable sigma_ : Universe.
Variable hazard_of_mortality_ : Universe -> Universe -> Universe.
Variable eta_ : Universe.
Variable age_ : Universe -> Universe -> Universe.

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable definition_1_7 : (forall X : Universe, (has_endowment_ X <-> (forall T : Universe, (organization_ X /\ ((smaller_or_equal_ (age_ X T) eta_ -> has_immunity_ X T) /\ (greater_ (age_ X T) eta_ -> ~(has_immunity_ X T))))))).
Variable assumption_2_8 : (forall X T0 T : Universe, ((organization_ X /\ (has_immunity_ X T0 /\ has_immunity_ X T)) -> (hazard_of_mortality_ X T0) = (hazard_of_mortality_ X T))).
Variable assumption_3_9 : (forall X T0 T : Universe, ((organization_ X /\ (has_immunity_ X T0 /\ ~(has_immunity_ X T))) -> greater_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0))).

Theorem lemma_9_10 : (forall X T0 T1 T2 : Universe, ((organization_ X /\ (has_endowment_ X /\ ((age_ X T0) = zero_ /\ (smaller_or_equal_ (age_ X T1) eta_ /\ (greater_ (age_ X T2) eta_ /\ (greater_or_equal_ eta_ sigma_ /\ greater_ sigma_ zero_)))))) -> (greater_ (hazard_of_mortality_ X T2) (hazard_of_mortality_ X T1) /\ (hazard_of_mortality_ X T1) = (hazard_of_mortality_ X T0)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
