(*
% File     : MGT055+1 : ILTP v1.1.2
% Domain   : Management (Organisation Theory)
% Problem  : Conditions for a constant then jumping hazard of mortality 1
% Version  : [Han98] axioms.
% English  : When (`eta' < `sigma') in a drifting environment, an endowed
%            organization's hazard of mortality remains constant until age
%            reaches `eta', then jumps to a higher level, then jumps again at
%            age `sigma'.
% Refs     : [Kam00] Kamps (2000), Email to G. Sutcliffe
%            [CH00]  Carroll & Hannan (2000), The Demography of Corporation
%            [Han98] Hannan (1998), Rethinking Age Dependence in Organizati
% Source   : [Kam00]
% Names    : LEMMA 8 [Han98]
% Status   : Theorem
% Rating   : 0.45 v3.1.0, 0.44 v2.7.0, 0.33 v2.6.0, 0.67 v2.5.0, 0.50 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   15 (   0 unit)
%            Number of atoms       :   62 (   8 equality)
%            Maximal formula depth :   15 (   7 average)
%            Number of connectives :   54 (   7 ~  ;   4  |;  26  &)
%                                         (   7 <=>;  10 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   10 (   0 propositional; 1-3 arity)
%            Number of functors    :    6 (   3 constant; 0-2 arity)
%            Number of variables   :   40 (   0 singleton;  40 !;   0 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : See MGT042+1.p for the mnemonic names.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable smaller_or_equal_ : Universe -> Universe -> Prop.
Variable smaller_ : Universe -> Universe -> Prop.
Variable organization_ : Universe -> Prop.
Variable is_aligned_ : Universe -> Universe -> Prop.
Variable has_immunity_ : Universe -> Universe -> Prop.
Variable has_endowment_ : Universe -> Prop.
Variable greater_or_equal_ : Universe -> Universe -> Prop.
Variable greater_ : Universe -> Universe -> Prop.
Variable dissimilar_ : Universe -> Universe -> Universe -> Prop.

Variable zero_ : Universe.
Variable sigma_ : Universe.
Variable hazard_of_mortality_ : Universe -> Universe -> Universe.
Variable eta_ : Universe.
Variable capability_ : Universe -> Universe -> Universe.
Variable age_ : Universe -> Universe -> Universe.

Variable definition_smaller_or_equal_1 : (forall X Y : Universe, (smaller_or_equal_ X Y <-> (smaller_ X Y \/ X = Y))).
Variable definition_greater_or_equal_2 : (forall X Y : Universe, (greater_or_equal_ X Y <-> (greater_ X Y \/ X = Y))).
Variable definition_smaller_3 : (forall X Y : Universe, (smaller_ X Y <-> greater_ Y X)).
Variable meaning_postulate_greater_strict_4 : (forall X Y : Universe, ~((greater_ X Y /\ greater_ Y X))).
Variable meaning_postulate_greater_transitive_5 : (forall X Y Z : Universe, ((greater_ X Y /\ greater_ Y Z) -> greater_ X Z)).
Variable meaning_postulate_greater_comparable_6 : (forall X Y : Universe, (smaller_ X Y \/ (X = Y \/ greater_ X Y))).
Variable definition_1_7 : (forall X : Universe, (has_endowment_ X <-> (forall T : Universe, (organization_ X /\ ((smaller_or_equal_ (age_ X T) eta_ -> has_immunity_ X T) /\ (greater_ (age_ X T) eta_ -> ~(has_immunity_ X T))))))).
Variable assumption_2_8 : (forall X T0 T : Universe, ((organization_ X /\ (has_immunity_ X T0 /\ has_immunity_ X T)) -> (hazard_of_mortality_ X T0) = (hazard_of_mortality_ X T))).
Variable assumption_3_9 : (forall X T0 T : Universe, ((organization_ X /\ (has_immunity_ X T0 /\ ~(has_immunity_ X T))) -> greater_ (hazard_of_mortality_ X T) (hazard_of_mortality_ X T0))).
Variable definition_2_10 : (forall X T0 T : Universe, (dissimilar_ X T0 T <-> (organization_ X /\ ~((is_aligned_ X T0 <-> is_aligned_ X T))))).
Variable assumption_13_11 : (forall X T : Universe, ((organization_ X /\ (age_ X T) = zero_) -> is_aligned_ X T)).
Variable assumption_14_12 : (forall X T0 T : Universe, ((organization_ X /\ (is_aligned_ X T0 /\ ~(is_aligned_ X T))) -> greater_ (capability_ X T0) (capability_ X T))).
Variable assumption_15_13 : (forall X T0 T : Universe, ((organization_ X /\ (age_ X T0) = zero_) -> (greater_ (age_ X T) sigma_ <-> dissimilar_ X T0 T))).
Variable assumption_16_14 : (forall X T0 T : Universe, ((organization_ X /\ (~(has_immunity_ X T0) /\ (~(has_immunity_ X T) /\ greater_ (capability_ X T) (capability_ X T0)))) -> greater_ (hazard_of_mortality_ X T0) (hazard_of_mortality_ X T))).

Theorem lemma_8_15 : (forall X T0 T1 T2 T3 : Universe, ((organization_ X /\ (has_endowment_ X /\ ((age_ X T0) = zero_ /\ (smaller_or_equal_ (age_ X T1) eta_ /\ (greater_ (age_ X T2) eta_ /\ (smaller_or_equal_ (age_ X T2) sigma_ /\ (greater_ (age_ X T3) sigma_ /\ (greater_ sigma_ eta_ /\ greater_ eta_ zero_)))))))) -> (greater_ (hazard_of_mortality_ X T3) (hazard_of_mortality_ X T2) /\ (greater_ (hazard_of_mortality_ X T2) (hazard_of_mortality_ X T1) /\ (hazard_of_mortality_ X T1) = (hazard_of_mortality_ X T0))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
